<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require_once '../../config/database.php';
require_once '../../includes/database.php';
require_once '../../includes/session_manager.php';

echo '<h1>Debug Info</h1>';
echo '<p>Session Permission: ' . (['permission_level'] ?? 'NOT SET') . '</p>';

if ((['permission_level'] ?? 0) < 30) {
    die('Access denied - permission level too low.');
}

$pdo = get_database_connection();
echo '<p>Database connected: YES</p>';

// Test locations query
$locations = $pdo->query("SELECT id, name FROM " . DB_PREFIX . "work_locations WHERE status = 'active' LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);
echo '<p>Locations found: ' . count($locations) . '</p>';
echo '<pre>' . print_r($locations, true) . '</pre>';

// Test workers query
$stmt = $pdo->prepare("SELECT wla.*, w.full_name, w.job_title FROM " . DB_PREFIX . "worker_location_assignments wla INNER JOIN " . DB_PREFIX . "sponsored_workers w ON wla.worker_id = w.id WHERE wla.location_id = ? LIMIT 5");
if (!empty($locations)) {
    $stmt->execute([$locations[0]['id']]);
    $workers = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo '<p>Workers at first location: ' . count($workers) . '</p>';
    echo '<pre>' . print_r($workers, true) . '</pre>';
}
