-- Attendance Tracking Module - Database Schema for SCMS v3.0

CREATE TABLE IF NOT EXISTS scms_attendance_records (
  id INT AUTO_INCREMENT PRIMARY KEY,
  worker_id INT NOT NULL,
  date DATE NOT NULL,
  status ENUM('P','PL','UL','FO','HO','WE','A') NOT NULL,
  check_in TIME DEFAULT NULL,
  check_out TIME DEFAULT NULL,
  hours DECIMAL(4,2) DEFAULT 0.00,
  is_late TINYINT(1) DEFAULT 0,
  is_early_leave TINYINT(1) DEFAULT 0,
  overtime_hours DECIMAL(4,2) DEFAULT 0.00,
  notes TEXT DEFAULT NULL,
  location_id INT DEFAULT NULL,
  created_by INT DEFAULT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  updated_by INT DEFAULT NULL,
  updated_at TIMESTAMP NULL ON UPDATE CURRENT_TIMESTAMP,
  edit_reason VARCHAR(255) DEFAULT NULL,
  UNIQUE KEY unique_attendance (worker_id, date),
  FOREIGN KEY (worker_id) REFERENCES scms_sponsored_workers(id) ON DELETE CASCADE,
  INDEX idx_date (date),
  INDEX idx_status (status)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS scms_attendance_absence_alerts (
  id INT AUTO_INCREMENT PRIMARY KEY,
  worker_id INT NOT NULL,
  absence_start_date DATE NOT NULL,
  absence_end_date DATE DEFAULT NULL,
  consecutive_days INT DEFAULT 0,
  alert_triggered TINYINT(1) DEFAULT 0,
  alert_threshold INT DEFAULT 10,
  ho_reported TINYINT(1) DEFAULT 0,
  ho_report_date DATE DEFAULT NULL,
  ho_report_ref VARCHAR(100) DEFAULT NULL,
  status ENUM('active','resolved','reported') DEFAULT 'active',
  notes TEXT,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (worker_id) REFERENCES scms_sponsored_workers(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS scms_bank_holidays (
  id INT AUTO_INCREMENT PRIMARY KEY,
  date DATE NOT NULL,
  name VARCHAR(255) NOT NULL,
  region VARCHAR(50) DEFAULT 'UK',
  UNIQUE KEY date_region (date, region)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
