<?php
/**
 * Create Module Settings Table
 */
require_once '../../config/database.php';
require_once '../../includes/database.php';

try {
    $pdo = get_database_connection();

    // Create module_settings table
    $sql = "CREATE TABLE IF NOT EXISTS " . DB_PREFIX . "module_settings (
        id INT AUTO_INCREMENT PRIMARY KEY,
        module_name VARCHAR(50) NOT NULL,
        setting_key VARCHAR(100) NOT NULL,
        setting_value TEXT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        UNIQUE KEY unique_setting (module_name, setting_key),
        INDEX idx_module (module_name)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

    $pdo->exec($sql);

    echo "SUCCESS: Module settings table created\n";

    // Insert default settings for attendance module
    $defaults = [
        ['attendance', 'enable_night_shift_conflicts', '1'],
        ['attendance', 'enable_same_day_conflicts', '1'],
        ['attendance', 'auto_resolve_conflicts', '0'],
        ['attendance', 'enable_roster_overrides', '1'],
        ['attendance', 'enable_roster_leave_auth', '1'],
        ['attendance', 'auto_mark_roster_leaves', '1'],
        ['attendance', 'require_auth_pl', '1'],
        ['attendance', 'require_auth_fo', '1'],
        ['attendance', 'require_auth_ho', '1'],
        ['attendance', 'require_auth_ul', '1'],
        ['attendance', 'require_auth_ml', '1'],
        ['attendance', 'enable_tracking_badges', '1'],
        ['attendance', 'show_authorization_details', '1'],
        ['attendance', 'date_format', 'DD/MM/YYYY'],
        ['attendance', 'use_british_english', '1'],
    ];

    $stmt = $pdo->prepare("INSERT IGNORE INTO " . DB_PREFIX . "module_settings (module_name, setting_key, setting_value) VALUES (?, ?, ?)");

    foreach ($defaults as $setting) {
        $stmt->execute($setting);
    }

    echo "SUCCESS: Default settings inserted\n";

} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}
?>
