<?php
/**
 * Create Roster Overrides Table
 */
require_once '../../config/database.php';
require_once '../../includes/database.php';

$pdo = get_database_connection();

$sql = "CREATE TABLE IF NOT EXISTS " . DB_PREFIX . "roster_overrides (
    id INT AUTO_INCREMENT PRIMARY KEY,
    worker_id INT NOT NULL,
    location_id INT NOT NULL,
    roster_date DATE NOT NULL,
    override_type ENUM('add', 'remove') NOT NULL DEFAULT 'add',
    shift_pattern_id INT NULL,
    shift_name VARCHAR(100) NULL,
    start_time TIME NULL,
    end_time TIME NULL,
    notes TEXT NULL,
    authorized_by INT NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_worker_date (worker_id, roster_date),
    INDEX idx_location_date (location_id, roster_date),
    INDEX idx_roster_date (roster_date),
    FOREIGN KEY (worker_id) REFERENCES " . DB_PREFIX . "sponsored_workers(id) ON DELETE CASCADE,
    FOREIGN KEY (location_id) REFERENCES " . DB_PREFIX . "work_locations(id) ON DELETE CASCADE,
    FOREIGN KEY (shift_pattern_id) REFERENCES " . DB_PREFIX . "location_shift_patterns(id) ON DELETE SET NULL,
    FOREIGN KEY (authorized_by) REFERENCES " . DB_PREFIX . "users(id) ON DELETE CASCADE,
    UNIQUE KEY unique_override (worker_id, location_id, roster_date)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

try {
    $pdo->exec($sql);
    echo "✓ Roster overrides table created successfully!\n";
    echo "Table: " . DB_PREFIX . "roster_overrides\n";
} catch (PDOException $e) {
    echo "✗ Error creating table: " . $e->getMessage() . "\n";
}
?>
