<?php
/**
 * Create Absence Authorizations Table
 */
require_once '../../config/database.php';
require_once '../../includes/database.php';

$pdo = get_database_connection();

$sql = "CREATE TABLE IF NOT EXISTS " . DB_PREFIX . "absence_authorizations (
    id INT AUTO_INCREMENT PRIMARY KEY,
    attendance_record_id INT NOT NULL,
    worker_id INT NOT NULL,
    attendance_date DATE NOT NULL,
    absence_type ENUM('PL', 'FO', 'HO', 'UL', 'ML') NOT NULL,
    authorized_by INT NOT NULL,
    authorization_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,

    -- Time tracking for Half Day Off (HO)
    half_day_period ENUM('first_half', 'second_half', 'custom') NULL COMMENT 'First or second half of day for HO',
    time_from TIME NULL COMMENT 'Start time for custom half-day or full absence',
    time_to TIME NULL COMMENT 'End time for custom half-day',

    -- Notes and tracking
    notes TEXT NULL COMMENT 'Reason for absence or additional notes',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,

    -- Indexes
    INDEX idx_attendance_record (attendance_record_id),
    INDEX idx_worker_date (worker_id, attendance_date),
    INDEX idx_authorized_by (authorized_by),
    INDEX idx_absence_type (absence_type),
    INDEX idx_auth_date (authorization_date),

    -- Foreign keys
    FOREIGN KEY (attendance_record_id) REFERENCES " . DB_PREFIX . "attendance_records(id) ON DELETE CASCADE,
    FOREIGN KEY (worker_id) REFERENCES " . DB_PREFIX . "sponsored_workers(id) ON DELETE CASCADE,
    FOREIGN KEY (authorized_by) REFERENCES " . DB_PREFIX . "users(id) ON DELETE CASCADE,

    -- Unique constraint - one authorization per attendance record
    UNIQUE KEY unique_attendance_auth (attendance_record_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

try {
    $pdo->exec($sql);
    echo "✓ Absence authorizations table created successfully!\n";
    echo "Table: " . DB_PREFIX . "absence_authorizations\n";
} catch (PDOException $e) {
    echo "✗ Error creating table: " . $e->getMessage() . "\n";
}
?>
