<?php
session_start();
require_once '../../config/database.php';
require_once '../../includes/database.php';
require_once '../../includes/session_manager.php';

require_authentication();

header('Content-Type: text/plain');

// Check Abdul Rauf Awan's details
$stmt = $pdo->prepare("SELECT id, employee_number, full_name, status FROM " . DB_PREFIX . "sponsored_workers WHERE full_name LIKE ?");
$stmt->execute(['%Abdul Rauf%']);
$worker = $stmt->fetch(PDO::FETCH_ASSOC);

if ($worker) {
    echo "Worker Details:\n";
    echo "ID: {$worker['id']}\n";
    echo "Employee Number: {$worker['employee_number']}\n";
    echo "Full Name: {$worker['full_name']}\n";
    echo "Status: {$worker['status']}\n\n";

    // Check attendance records for this worker
    $stmt2 = $pdo->prepare("SELECT attendance_date, status, id FROM " . DB_PREFIX . "attendance_records WHERE worker_id = ? AND attendance_date BETWEEN ? AND ? ORDER BY attendance_date");
    $stmt2->execute([$worker['id'], '2025-10-01', '2025-10-31']);
    $records = $stmt2->fetchAll(PDO::FETCH_ASSOC);

    echo "Attendance Records for October 2025:\n";
    echo str_repeat("=", 50) . "\n";
    if (empty($records)) {
        echo "No records found!\n";
    } else {
        foreach ($records as $rec) {
            echo "{$rec['attendance_date']} - {$rec['status']} (ID: {$rec['id']})\n";
        }
    }
    echo "\nTotal: " . count($records) . " records\n";
} else {
    echo "Worker not found!\n";
}
