<?php
session_start();
require_once '../../config/database.php';
require_once '../../includes/database.php';
require_once '../../includes/session_manager.php';

require_authentication();

header('Content-Type: text/plain');

$today = date('Y-m-d');

echo "=== ATTENDANCE RECORDS FOR TODAY ($today) ===\n\n";

// Get all attendance records for today with worker details
$stmt = $pdo->query("
    SELECT a.*, w.full_name, w.employee_number, w.department, w.status as worker_status
    FROM scms_attendance_records a
    JOIN scms_sponsored_workers w ON a.worker_id = w.id
    WHERE a.attendance_date = '$today'
    ORDER BY w.full_name
");

$records = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (empty($records)) {
    echo "No attendance records found for today.\n";
} else {
    foreach ($records as $rec) {
        echo "Employee: {$rec['employee_number']} - {$rec['full_name']}\n";
        echo "Department: {$rec['department']}\n";
        echo "Worker Status: {$rec['worker_status']}\n";
        echo "Attendance Status: {$rec['status']}\n";
        echo "Record ID: {$rec['id']}\n";
        echo str_repeat("-", 50) . "\n";
    }
}

echo "\n=== SUMMARY ===\n";
echo "Total records today: " . count($records) . "\n";

$present_count = $pdo->query("SELECT COUNT(*) FROM scms_attendance_records WHERE attendance_date = '$today' AND status = 'P'")->fetchColumn();
echo "Total Present (P) today: $present_count\n";

$absent_count = $pdo->query("SELECT COUNT(*) FROM scms_attendance_records WHERE attendance_date = '$today' AND status = 'A'")->fetchColumn();
echo "Total Absent (A) today: $absent_count\n";

// Check active workers
$active_workers = $pdo->query("SELECT COUNT(*) FROM scms_sponsored_workers WHERE status = 'active'")->fetchColumn();
echo "\nTotal active workers in system: $active_workers\n";
