<?php
session_start();
require_once '../../config/database.php';
require_once '../../includes/database.php';
require_once '../../includes/session_manager.php';

require_authentication();

// Get Abdul Rauf Awan's attendance records for October 2025
$stmt = $pdo->prepare("
    SELECT w.employee_number, w.full_name, a.attendance_date, a.status, a.id
    FROM " . DB_PREFIX . "attendance_records a
    JOIN " . DB_PREFIX . "sponsored_workers w ON a.worker_id = w.id
    WHERE w.full_name LIKE ?
    AND a.attendance_date BETWEEN ? AND ?
    ORDER BY a.attendance_date
");

$stmt->execute(['%Abdul Rauf%', '2025-10-01', '2025-10-31']);
$records = $stmt->fetchAll(PDO::FETCH_ASSOC);

header('Content-Type: text/plain');
echo "Attendance Records for Abdul Rauf Awan in October 2025:\n";
echo str_repeat("=", 70) . "\n\n";

if (empty($records)) {
    echo "No records found!\n";
} else {
    foreach ($records as $record) {
        echo "Date: {$record['attendance_date']} | Status: {$record['status']} | ID: {$record['id']}\n";
    }
}

echo "\n\nTotal records: " . count($records);
