<?php
/**
 * Get Authorization Details
 * Fetch detailed information about an absence authorization
 */
session_start();
require_once '../../../config/database.php';
require_once '../../../includes/database.php';
require_once '../../../includes/session_manager.php';

header('Content-Type: application/json');

// Check authentication
if (!is_authenticated()) {
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit;
}

try {
    $pdo = get_database_connection();

    // Get JSON input
    $input = json_decode(file_get_contents('php://input'), true);

    if (!$input) {
        echo json_encode(['success' => false, 'message' => 'Invalid JSON input']);
        exit;
    }

    $worker_id = intval($input['worker_id'] ?? 0);
    $date = $input['date'] ?? '';

    // Validate
    if (!$worker_id || !$date) {
        echo json_encode(['success' => false, 'message' => 'Missing required fields']);
        exit;
    }

    // Fetch authorization with joined data
    $stmt = $pdo->prepare("SELECT
        aa.*,
        sw.full_name as worker_name,
        u.username as authorized_by_name,
        u.full_name as authorized_by_fullname
        FROM " . DB_PREFIX . "absence_authorizations aa
        LEFT JOIN " . DB_PREFIX . "sponsored_workers sw ON aa.worker_id = sw.id
        LEFT JOIN " . DB_PREFIX . "users u ON aa.authorized_by = u.id
        WHERE aa.worker_id = ?
        AND aa.attendance_date = ?
        LIMIT 1");

    $stmt->execute([$worker_id, $date]);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($result) {
        // Use full name if available, otherwise username
        $result['authorized_by_name'] = $result['authorized_by_fullname'] ?: $result['authorized_by_name'];

        echo json_encode([
            'success' => true,
            'data' => $result
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Authorization record not found'
        ]);
    }

} catch (Exception $e) {
    error_log('Get authorization details error: ' . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>
