<?php
/**
 * AJAX Handler - Delete Roster Override
 */
session_start();
require_once '../../../config/database.php';
require_once '../../../includes/database.php';
require_once '../../../includes/session_manager.php';

header('Content-Type: application/json');

// Check authentication
if (!is_user_logged_in()) {
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit;
}

// Check permission
if (($_SESSION['permission_level'] ?? 0) < 30) {
    echo json_encode(['success' => false, 'message' => 'Insufficient permissions']);
    exit;
}

try {
    $pdo = get_database_connection();

    $id = intval($_POST['id'] ?? 0);

    if ($id <= 0) {
        echo json_encode(['success' => false, 'message' => 'Invalid ID']);
        exit;
    }

    $stmt = $pdo->prepare("DELETE FROM " . DB_PREFIX . "roster_overrides WHERE id = ?");
    $stmt->execute([$id]);

    echo json_encode(['success' => true, 'message' => 'Roster override deleted successfully']);

} catch (Exception $e) {
    error_log('Error deleting roster override: ' . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
