<?php
/**
 * Database Update Script for Users Table
 * Ensures users table has all required columns
 */

require_once '../../config/database.php';
require_once '../../includes/database.php';
require_once '../../includes/error_logger.php';

try {
    // Check if worker_id column exists
    $stmt = $pdo->query("SHOW COLUMNS FROM " . DB_PREFIX . "users LIKE 'worker_id'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE " . DB_PREFIX . "users ADD COLUMN worker_id INT NULL AFTER permission_level");
        echo "Added worker_id column\n";
        log_error('DATABASE_UPDATE', 'Added worker_id column to users table', [], 'info');
    }

    // Check if phone column exists
    $stmt = $pdo->query("SHOW COLUMNS FROM " . DB_PREFIX . "users LIKE 'phone'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE " . DB_PREFIX . "users ADD COLUMN phone VARCHAR(20) NULL AFTER email");
        echo "Added phone column\n";
        log_error('DATABASE_UPDATE', 'Added phone column to users table', [], 'info');
    }

    // Check if user_role column exists
    $stmt = $pdo->query("SHOW COLUMNS FROM " . DB_PREFIX . "users LIKE 'user_role'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE " . DB_PREFIX . "users ADD COLUMN user_role VARCHAR(100) NULL AFTER full_name");
        echo "Added user_role column\n";
        log_error('DATABASE_UPDATE', 'Added user_role column to users table', [], 'info');
    }

    // Check if permission_level column exists
    $stmt = $pdo->query("SHOW COLUMNS FROM " . DB_PREFIX . "users LIKE 'permission_level'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE " . DB_PREFIX . "users ADD COLUMN permission_level INT DEFAULT 30 AFTER user_role");
        echo "Added permission_level column\n";
        log_error('DATABASE_UPDATE', 'Added permission_level column to users table', [], 'info');
    }

    // Check if status column exists
    $stmt = $pdo->query("SHOW COLUMNS FROM " . DB_PREFIX . "users LIKE 'status'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE " . DB_PREFIX . "users ADD COLUMN status VARCHAR(20) DEFAULT 'active' AFTER worker_id");
        echo "Added status column\n";
        log_error('DATABASE_UPDATE', 'Added status column to users table', [], 'info');
    }

    // Check if login_count column exists
    $stmt = $pdo->query("SHOW COLUMNS FROM " . DB_PREFIX . "users LIKE 'login_count'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE " . DB_PREFIX . "users ADD COLUMN login_count INT DEFAULT 0 AFTER last_login_ip");
        echo "Added login_count column\n";
        log_error('DATABASE_UPDATE', 'Added login_count column to users table', [], 'info');
    }

    echo "Database update completed successfully!\n";

} catch (PDOException $e) {
    echo "Database update failed: " . $e->getMessage() . "\n";
    log_error('DATABASE_ERROR', 'Failed to update users table', [
        'error' => $e->getMessage()
    ]);
}
?>
