<?php
/**
 * Add first_name, last_name, phone columns to users table
 */

require_once 'config/database.php';
require_once 'includes/database.php';

try {
    echo "Adding first_name, last_name, and phone columns to users table...\n";

    $pdo->exec("ALTER TABLE " . DB_PREFIX . "users
        ADD COLUMN first_name VARCHAR(100) NULL AFTER username,
        ADD COLUMN last_name VARCHAR(100) NULL AFTER first_name,
        ADD COLUMN phone VARCHAR(20) NULL AFTER email
    ");

    echo "Columns added successfully!\n";

    // Set default values from username if null
    echo "Setting default first_name from username for existing users...\n";
    $pdo->exec("UPDATE " . DB_PREFIX . "users
        SET first_name = username
        WHERE first_name IS NULL OR first_name = ''
    ");

    echo "Migration completed successfully!\n";

} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}
