<?php
/**
 * Migrate modules_registry table to new schema
 */

require_once 'config/database.php';
require_once 'includes/database.php';

try {
    echo "Migrating modules_registry table...\n";

    // Add new columns
    $pdo->exec("ALTER TABLE " . DB_PREFIX . "modules_registry
        ADD COLUMN module_id VARCHAR(50) AFTER id,
        ADD COLUMN name VARCHAR(100) AFTER module_id,
        ADD COLUMN description TEXT AFTER name,
        ADD COLUMN version VARCHAR(20) AFTER description,
        ADD COLUMN author VARCHAR(100) AFTER version,
        ADD COLUMN icon VARCHAR(50) AFTER author,
        ADD COLUMN settings JSON AFTER status,
        ADD COLUMN sort_order INT DEFAULT 0 AFTER settings,
        ADD COLUMN activated_at TIMESTAMP NULL AFTER installed_at,
        ADD COLUMN updated_at TIMESTAMP NULL AFTER activated_at
    ");

    echo "Added new columns\n";

    // Copy data from old columns to new
    $pdo->exec("UPDATE " . DB_PREFIX . "modules_registry
        SET version = module_version,
            name = module_name
    ");

    echo "Copied data from old columns\n";

    // Add unique index on module_id
    $pdo->exec("ALTER TABLE " . DB_PREFIX . "modules_registry
        ADD UNIQUE KEY unique_module_id (module_id)
    ");

    echo "Added unique index on module_id\n";

    echo "Migration completed successfully!\n";

} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}
