<?php
/**
 * Logout Script
 * Destroys session and redirects to login
 */

session_start();

// Get user info for audit log before destroying session
$user_id = $_SESSION['user_id'] ?? null;

// Log the logout action
if ($user_id) {
    try {
        require_once 'config/database.php';

        $stmt = $pdo->prepare("INSERT INTO " . DB_PREFIX . "audit_logs (user_id, action, ip_address, created_at) VALUES (?, 'User logged out', ?, NOW())");
        $stmt->execute([$user_id, $_SERVER['REMOTE_ADDR']]);
    } catch (Exception $e) {
        // Silent fail - don't prevent logout
        error_log('Logout audit log failed: ' . $e->getMessage());
    }
}

// Destroy all session data
$_SESSION = array();

// Destroy the session cookie
if (isset($_COOKIE[session_name()])) {
    setcookie(session_name(), '', time() - 3600, '/');
}

// Destroy the session
session_destroy();

// Redirect to login page
header('Location: login.php?logged_out=1');
exit;
