<?php
/**
 * Work Locations Management
 */

session_start();
require_once 'config/database.php';
require_once 'includes/database.php';
require_once 'includes/session_manager.php';

require_authentication();

// Get current user
$current_user = get_logged_in_user();
if (!$current_user) {
    header('Location: login.php');
    exit;
}

$page_title = 'Work Locations';
$current_page = 'locations';

// Include header with sidebar
include 'includes/header.php';

// Set embedded flag
define('MODULE_EMBEDDED', true);
?>

<div class="dashboard-container">
    <?php include 'modules/locations/list.php'; ?>
</div>

<?php include 'includes/footer.php'; ?>
