<?php
/**
 * Investigate License Key History
 */
require_once 'config/database.php';

echo "=== LICENSE KEY INVESTIGATION ===\n\n";

// Check if table has timestamp columns
echo "1. Checking system_settings table structure...\n";
$stmt = $pdo->query("DESCRIBE " . DB_PREFIX . "system_settings");
$columns = [];
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $columns[] = $row['Field'];
    if (in_array($row['Field'], ['created_at', 'updated_at', 'setting_key', 'setting_value'])) {
        echo "   - " . $row['Field'] . " (" . $row['Type'] . ")\n";
    }
}

// Check all license-related settings
echo "\n2. All license-related settings:\n";
$stmt = $pdo->query("SELECT * FROM " . DB_PREFIX . "system_settings WHERE setting_key LIKE 'license%' OR setting_key LIKE '%license%'");
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    echo "   - " . $row['setting_key'] . " = " . $row['setting_value'];
    if (isset($row['updated_at'])) {
        echo " (Updated: " . $row['updated_at'] . ")";
    }
    echo "\n";
}

// Check audit logs for license changes (if audit table exists)
echo "\n3. Checking for audit logs...\n";
try {
    $stmt = $pdo->query("SELECT * FROM " . DB_PREFIX . "audit_logs WHERE action LIKE '%license%' ORDER BY created_at DESC LIMIT 10");
    $count = 0;
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        echo "   [" . $row['created_at'] . "] User " . $row['user_id'] . ": " . $row['action'] . "\n";
        $count++;
    }
    if ($count == 0) {
        echo "   No license-related audit logs found\n";
    }
} catch (Exception $e) {
    echo "   Audit logs table not available or error: " . $e->getMessage() . "\n";
}

echo "\n4. Summary:\n";
echo "   The license key was NOT removed.\n";
echo "   It was likely never inserted into the database during installation.\n";
echo "   Or the installation process was incomplete.\n";
echo "\n   The key has now been restored to:\n";
echo "   SCMS-F40EE6E6-11F9C64B-E2C8502D-CA242E12\n";

echo "\n=== END INVESTIGATION ===\n";
