<?php
/**
 * Install workers module database tables
 */

require_once 'config/database.php';
require_once 'includes/database.php';

echo "Installing workers module database tables...\n\n";

try {
    // Read the SQL file
    $sql_file = 'modules/workers/database_schema.sql';

    if (!file_exists($sql_file)) {
        die("ERROR: SQL file not found: {$sql_file}\n");
    }

    $sql = file_get_contents($sql_file);

    // Execute the SQL
    $pdo->exec($sql);

    echo "SUCCESS: All workers module tables created!\n\n";

    // Verify
    $tables = [
        'scms_sponsored_workers',
        'scms_worker_documents',
        'scms_worker_cos_history',
        'scms_worker_contact_history',
        'scms_worker_employment_history',
        'scms_worker_rtw_checks',
        'scms_worker_notes'
    ];

    echo "Verifying tables:\n";
    foreach ($tables as $table) {
        $stmt = $pdo->query("SHOW TABLES LIKE '{$table}'");
        if ($stmt->rowCount() > 0) {
            echo "  ✓ {$table}\n";
        } else {
            echo "  ✗ {$table} - FAILED\n";
        }
    }

} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}
