<?php
/**
 * Step 6: Administrator Account
 */
?>

<h3 class="mb-4"><i class="bi bi-person-badge-fill"></i> Create Administrator Account</h3>

<div class="alert alert-gradient mb-4">
    <i class="bi bi-shield-lock-fill"></i> <strong>Security Features:</strong>
    <ul class="mb-0 mt-2 small">
        <li>Strong password encryption using bcrypt</li>
        <li>4-digit PIN for sensitive operations (deletions, PIN-protected data)</li>
        <li>Automatic session timeout after 20 minutes</li>
        <li>Complete audit trail of all actions</li>
    </ul>
</div>

<form method="POST" action="index.php?step=6" id="adminForm">
    <div class="row">
        <div class="col-md-6 mb-4">
            <label for="admin_first_name" class="form-label">
                <strong>First Name</strong> <span class="text-danger">*</span>
            </label>
            <input type="text" class="form-control form-control-lg" id="admin_first_name" name="admin_first_name"
                   value="<?php echo isset($_SESSION['admin_first_name']) ? htmlspecialchars($_SESSION['admin_first_name']) : ''; ?>"
                   required minlength="2" maxlength="100">
            <small class="form-text text-muted">Your first name for personalized greetings</small>
        </div>

        <div class="col-md-6 mb-4">
            <label for="admin_last_name" class="form-label">
                <strong>Last Name</strong> <span class="text-danger">*</span>
            </label>
            <input type="text" class="form-control form-control-lg" id="admin_last_name" name="admin_last_name"
                   value="<?php echo isset($_SESSION['admin_last_name']) ? htmlspecialchars($_SESSION['admin_last_name']) : ''; ?>"
                   required minlength="2" maxlength="100">
            <small class="form-text text-muted">Your last name</small>
        </div>
    </div>

    <div class="mb-4">
        <label for="admin_username" class="form-label">
            <strong>Username</strong> <span class="text-danger">*</span>
        </label>
        <input type="text" class="form-control form-control-lg" id="admin_username" name="admin_username"
               value="<?php echo isset($_SESSION['admin_username']) ? htmlspecialchars($_SESSION['admin_username']) : ''; ?>"
               required minlength="3" maxlength="50" pattern="[a-zA-Z0-9_-]+" autocomplete="off">
        <small class="form-text text-muted">3-50 characters, letters, numbers, underscore and hyphen only (no spaces)</small>
    </div>

    <div class="mb-4">
        <label for="admin_email" class="form-label">
            <strong>Email Address</strong> <span class="text-danger">*</span>
        </label>
        <input type="email" class="form-control form-control-lg" id="admin_email" name="admin_email"
               value="<?php echo isset($_SESSION['admin_email']) ? htmlspecialchars($_SESSION['admin_email']) : ''; ?>"
               required autocomplete="off">
        <small class="form-text text-muted">Used for password recovery and system notifications</small>
    </div>

    <div class="row">
        <div class="col-md-6 mb-3">
            <label for="admin_password" class="form-label">
                <strong>Password</strong> <span class="text-danger">*</span>
            </label>
            <div class="input-group">
                <input type="password" class="form-control" id="admin_password" name="admin_password"
                       required minlength="8" autocomplete="new-password">
                <button class="btn btn-outline-secondary" type="button" id="togglePassword">
                    <i class="bi bi-eye"></i>
                </button>
            </div>
            <div class="form-text">
                <small>
                    <i class="bi bi-check-circle text-success" id="length-check"></i> At least 8 characters<br>
                    <i class="bi bi-circle text-muted" id="upper-check"></i> At least one uppercase letter<br>
                    <i class="bi bi-circle text-muted" id="number-check"></i> At least one number
                </small>
            </div>
        </div>

        <div class="col-md-6 mb-3">
            <label for="confirm_password" class="form-label">
                <strong>Confirm Password</strong> <span class="text-danger">*</span>
            </label>
            <input type="password" class="form-control" id="confirm_password" name="confirm_password"
                   required minlength="8" autocomplete="new-password">
            <small class="form-text text-muted" id="match-message"></small>
        </div>
    </div>

    <div class="mb-4">
        <label for="admin_pin" class="form-label">
            <strong>4-Digit Security PIN</strong> <span class="text-danger">*</span>
        </label>
        <input type="password" class="form-control form-control-lg text-center" id="admin_pin" name="admin_pin"
               required pattern="[0-9]{4}" maxlength="4" inputmode="numeric" style="max-width: 200px;" autocomplete="off">
        <small class="form-text text-muted">Required for sensitive operations like deleting workers or accessing confidential notes</small>
    </div>

    <div class="card border-warning mb-4">
        <div class="card-body">
            <h6 class="text-warning"><i class="bi bi-exclamation-triangle-fill"></i> Important:</h6>
            <ul class="small mb-0">
                <li>This will be the <strong>system administrator</strong> account with full access (Permission Level 100)</li>
                <li>You can create additional users with different permission levels later</li>
                <li><strong>Remember your PIN!</strong> It cannot be recovered and is required for critical operations</li>
            </ul>
        </div>
    </div>

    <div class="d-grid gap-2">
        <button type="submit" class="btn btn-primary btn-lg">
            <i class="bi bi-arrow-right-circle-fill"></i> Continue to Installation
        </button>
        <a href="index.php?step=5" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left-circle"></i> Back to Business Profile
        </a>
    </div>
</form>

<script>
// Password strength validation
const password = document.getElementById('admin_password');
const confirmPassword = document.getElementById('confirm_password');

password.addEventListener('input', function() {
    const value = this.value;

    // Length check
    if (value.length >= 8) {
        document.getElementById('length-check').className = 'bi bi-check-circle text-success';
    } else {
        document.getElementById('length-check').className = 'bi bi-circle text-muted';
    }

    // Uppercase check
    if (/[A-Z]/.test(value)) {
        document.getElementById('upper-check').className = 'bi bi-check-circle text-success';
    } else {
        document.getElementById('upper-check').className = 'bi bi-circle text-muted';
    }

    // Number check
    if (/[0-9]/.test(value)) {
        document.getElementById('number-check').className = 'bi bi-check-circle text-success';
    } else {
        document.getElementById('number-check').className = 'bi bi-circle text-muted';
    }
});

// Password match validation
confirmPassword.addEventListener('input', function() {
    const matchMessage = document.getElementById('match-message');
    if (this.value === password.value && this.value.length > 0) {
        matchMessage.textContent = '✓ Passwords match';
        matchMessage.className = 'form-text text-success';
    } else if (this.value.length > 0) {
        matchMessage.textContent = '✗ Passwords do not match';
        matchMessage.className = 'form-text text-danger';
    } else {
        matchMessage.textContent = '';
    }
});

// Toggle password visibility
document.getElementById('togglePassword').addEventListener('click', function() {
    const type = password.type === 'password' ? 'text' : 'password';
    password.type = type;
    confirmPassword.type = type;
    this.querySelector('i').className = type === 'password' ? 'bi bi-eye' : 'bi bi-eye-slash';
});

// Form validation
document.getElementById('adminForm').addEventListener('submit', function(e) {
    if (password.value !== confirmPassword.value) {
        e.preventDefault();
        alert('Passwords do not match!');
        confirmPassword.focus();
        return false;
    }

    const pinValue = document.getElementById('admin_pin').value;
    if (!/^[0-9]{4}$/.test(pinValue)) {
        e.preventDefault();
        alert('PIN must be exactly 4 digits!');
        document.getElementById('admin_pin').focus();
        return false;
    }
});

// Username validation - no spaces
document.getElementById('admin_username').addEventListener('input', function() {
    this.value = this.value.replace(/\s/g, '');
});
</script>
