<?php
/**
 * Step 4: Database Configuration
 */
?>

<h3 class="mb-4"><i class="bi bi-database-fill"></i> Database Configuration</h3>

<div class="alert alert-info">
    <i class="bi bi-info-circle-fill"></i> <strong>Database Setup:</strong>
    Enter your MySQL database credentials. The database must already exist - create it via cPanel if needed.
</div>

<form method="POST" action="install.php?step=4">
    <div class="mb-4">
        <label for="db_host" class="form-label">
            <strong>Database Host</strong> <span class="text-danger">*</span>
        </label>
        <input type="text" class="form-control form-control-lg" id="db_host" name="db_host"
               value="<?php echo isset($_SESSION['db_host']) ? htmlspecialchars($_SESSION['db_host']) : 'localhost'; ?>" required>
        <small class="form-text text-muted">Usually "localhost" for cPanel hosting</small>
    </div>

    <div class="mb-4">
        <label for="db_name" class="form-label">
            <strong>Database Name</strong> <span class="text-danger">*</span>
        </label>
        <input type="text" class="form-control form-control-lg" id="db_name" name="db_name"
               value="<?php echo isset($_SESSION['db_name']) ? htmlspecialchars($_SESSION['db_name']) : ''; ?>"
               placeholder="youruser_scms" required>
        <small class="form-text text-muted">The database must already exist</small>
    </div>

    <div class="mb-4">
        <label for="db_user" class="form-label">
            <strong>Database Username</strong> <span class="text-danger">*</span>
        </label>
        <input type="text" class="form-control form-control-lg" id="db_user" name="db_user"
               value="<?php echo isset($_SESSION['db_user']) ? htmlspecialchars($_SESSION['db_user']) : ''; ?>"
               placeholder="youruser_scms" required>
    </div>

    <div class="mb-4">
        <label for="db_pass" class="form-label">
            <strong>Database Password</strong> <span class="text-danger">*</span>
        </label>
        <input type="password" class="form-control form-control-lg" id="db_pass" name="db_pass"
               value="<?php echo isset($_SESSION['db_pass']) ? htmlspecialchars($_SESSION['db_pass']) : ''; ?>" required>
    </div>

    <div class="mb-4">
        <label for="db_prefix" class="form-label">
            <strong>Table Prefix</strong>
        </label>
        <input type="text" class="form-control" id="db_prefix" name="db_prefix"
               value="<?php echo isset($_SESSION['db_prefix']) ? htmlspecialchars($_SESSION['db_prefix']) : 'scms_'; ?>">
        <small class="form-text text-muted">Prefix for all database tables (default: scms_)</small>
    </div>

    <div class="card bg-light mb-4">
        <div class="card-body">
            <h6><i class="bi bi-lightbulb"></i> Need help?</h6>
            <p class="small mb-2">To create a MySQL database in cPanel:</p>
            <ol class="small mb-0">
                <li>Log into your cPanel</li>
                <li>Navigate to "MySQL Databases"</li>
                <li>Create a new database (e.g., youruser_scms)</li>
                <li>Create a new user with a strong password</li>
                <li>Add the user to the database with ALL PRIVILEGES</li>
                <li>Use these credentials here</li>
            </ol>
        </div>
    </div>

    <div class="d-grid gap-2">
        <button type="submit" class="btn btn-primary btn-lg">
            <i class="bi bi-check-circle-fill"></i> Test Connection & Continue
        </button>
        <a href="install.php?step=3" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left-circle"></i> Back to File Operations
        </a>
    </div>
</form>
