<?php
/**
 * Step 3: Business Profile Setup
 */
?>

<h3 class="mb-4"><i class="bi bi-building"></i> Business Profile</h3>

<div class="alert alert-info">
    <strong>Note:</strong> This information will be used across the system and in official reports.
</div>

<form method="POST" action="?step=3">
    <div class="row">
        <div class="col-md-6 mb-3">
            <label for="company_name" class="form-label">Company Name *</label>
            <input type="text" class="form-control" id="company_name" name="company_name"
                   value="<?php echo $_SESSION['company_name'] ?? ''; ?>" required>
        </div>

        <div class="col-md-6 mb-3">
            <label for="company_reg" class="form-label">Company Registration Number</label>
            <input type="text" class="form-control" id="company_reg" name="company_reg"
                   value="<?php echo $_SESSION['company_reg'] ?? ''; ?>">
        </div>
    </div>

    <div class="mb-3">
        <label for="industry" class="form-label">Industry Sector</label>
        <select class="form-select" id="industry" name="industry">
            <option value="">Select Industry...</option>
            <option value="Care" <?php echo ($_SESSION['industry'] ?? '') == 'Care' ? 'selected' : ''; ?>>Care & Health</option>
            <option value="Construction" <?php echo ($_SESSION['industry'] ?? '') == 'Construction' ? 'selected' : ''; ?>>Construction</option>
            <option value="IT" <?php echo ($_SESSION['industry'] ?? '') == 'IT' ? 'selected' : ''; ?>>Information Technology</option>
            <option value="Hospitality" <?php echo ($_SESSION['industry'] ?? '') == 'Hospitality' ? 'selected' : ''; ?>>Hospitality</option>
            <option value="Manufacturing" <?php echo ($_SESSION['industry'] ?? '') == 'Manufacturing' ? 'selected' : ''; ?>>Manufacturing</option>
            <option value="Education" <?php echo ($_SESSION['industry'] ?? '') == 'Education' ? 'selected' : ''; ?>>Education</option>
            <option value="Finance" <?php echo ($_SESSION['industry'] ?? '') == 'Finance' ? 'selected' : ''; ?>>Finance & Banking</option>
            <option value="Other" <?php echo ($_SESSION['industry'] ?? '') == 'Other' ? 'selected' : ''; ?>>Other</option>
        </select>
    </div>

    <div class="mb-3">
        <label for="address" class="form-label">Address</label>
        <input type="text" class="form-control" id="address" name="address"
               value="<?php echo $_SESSION['address'] ?? ''; ?>">
    </div>

    <div class="row">
        <div class="col-md-8 mb-3">
            <label for="city" class="form-label">City</label>
            <input type="text" class="form-control" id="city" name="city"
                   value="<?php echo $_SESSION['city'] ?? ''; ?>">
        </div>

        <div class="col-md-4 mb-3">
            <label for="postcode" class="form-label">Postcode</label>
            <input type="text" class="form-control" id="postcode" name="postcode"
                   value="<?php echo $_SESSION['postcode'] ?? ''; ?>">
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 mb-3">
            <label for="phone" class="form-label">Phone Number</label>
            <input type="tel" class="form-control" id="phone" name="phone"
                   value="<?php echo $_SESSION['phone'] ?? ''; ?>">
        </div>

        <div class="col-md-6 mb-3">
            <label for="email" class="form-label">Company Email</label>
            <input type="email" class="form-control" id="email" name="email"
                   value="<?php echo $_SESSION['email'] ?? ''; ?>">
        </div>
    </div>

    <div class="alert alert-secondary">
        <small><i class="bi bi-info-circle"></i> You can upload your company logo and add more details after installation.</small>
    </div>

    <div class="d-grid gap-2">
        <button type="submit" class="btn btn-primary">
            <i class="bi bi-arrow-right-circle"></i> Continue to Admin Setup
        </button>
        <a href="?step=2" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left-circle"></i> Back
        </a>
    </div>
</form>
