<?php
/**
 * Step 1: License Validation
 */
?>

<h3 class="mb-4"><i class="bi bi-key-fill"></i> License Validation</h3>

<div class="alert alert-info">
    <i class="bi bi-info-circle-fill"></i> <strong>License Required:</strong>
    SCMS requires a valid license key to install. Please enter your license details below.
</div>

<form method="POST" action="install.php?step=1">
    <div class="mb-4">
        <label for="license_key" class="form-label">
            <strong>License Key</strong> <span class="text-danger">*</span>
        </label>
        <input type="text" class="form-control form-control-lg" id="license_key" name="license_key"
               value="<?php echo isset($_SESSION['license_key']) ? htmlspecialchars($_SESSION['license_key']) : ''; ?>"
               placeholder="XXXX-XXXX-XXXX-XXXX" required>
        <small class="form-text text-muted">
            Enter the license key provided by your vendor
        </small>
    </div>

    <?php
    // Use extract_root_domain function from install.php (already declared)
    $root_domain = extract_root_domain($_SERVER['HTTP_HOST']);
    ?>
    <div class="mb-4">
        <label for="domain" class="form-label">
            <strong>License Domain</strong>
        </label>
        <input type="text" class="form-control form-control-lg" id="domain" name="domain"
               value="<?php echo $root_domain; ?>" readonly style="background-color: #e9ecef; cursor: not-allowed;">
        <small class="form-text text-muted">
            <i class="bi bi-lock-fill"></i> <strong>Root domain auto-detected.</strong> License will work on any subdomain/subfolder of <strong><?php echo $root_domain; ?></strong>
        </small>
    </div>

    <div class="mb-4">
        <label for="validator_url" class="form-label">
            <strong>License Validation Server</strong>
        </label>
        <input type="url" class="form-control" id="validator_url" name="validator_url"
               value="<?php echo isset($_SESSION['validator_url']) ? htmlspecialchars($_SESSION['validator_url']) : 'https://www.expremit.com/lic/api/validate.php'; ?>">
        <small class="form-text text-muted">
            Default: https://www.expremit.com/lic/api/validate.php (only change if instructed by support)
        </small>
    </div>

    <div class="card bg-light mb-4">
        <div class="card-body">
            <h6><i class="bi bi-question-circle"></i> Don't have a license?</h6>
            <p class="mb-2 small">Contact support to obtain a license key:</p>
            <ul class="small mb-0">
                <li>Email: <a href="mailto:abz@yours.com">abz@yours.com</a></li>
                <li>License Types: Free Trial (5 workers, 30 days) | Paid (Custom limits) | Unlimited (Lifetime)</li>
            </ul>
        </div>
    </div>

    <div class="d-grid gap-2">
        <button type="submit" class="btn btn-primary btn-lg">
            <i class="bi bi-shield-check"></i> Validate License & Continue
        </button>
        <a href="install.php?step=0" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left-circle"></i> Back to Welcome
        </a>
    </div>
</form>

<div class="mt-4">
    <details>
        <summary class="text-muted" style="cursor: pointer;">
            <small><i class="bi bi-gear"></i> Advanced: Cannot reach validation server?</small>
        </summary>
        <div class="mt-2 p-3 bg-light rounded">
            <p class="small mb-2">If you cannot reach the default validation server:</p>
            <ol class="small">
                <li>Check your server's firewall allows outbound HTTPS connections</li>
                <li>Ensure cURL or allow_url_fopen is enabled in PHP</li>
                <li>Contact support for an alternative validation server URL</li>
                <li>Enter the alternative URL in the "License Validation Server" field above</li>
            </ol>
        </div>
    </details>
</div>
