<?php
// Load global routes configuration
if (file_exists(__DIR__ . '/../config/routes.php')) {
    require_once __DIR__ . '/../config/routes.php';
} else {
    // Fallback if routes file not found
    define('BASE_PATH', '/sys/scms/');
}
?>
<!-- Sidebar Navigation -->
<aside id="sidebar" class="sidebar bg-white border-end" style="width: var(--sidebar-width); position: fixed; top: 0; left: 0; height: 100vh; overflow-y: auto; z-index: 1001; transition: transform 0.3s;">
    <!-- Logo -->
    <div class="sidebar-header p-3 border-bottom" style="height: var(--header-height);">
        <h4 class="mb-0 fw-bold text-primary">
            <i class="bi bi-shield-check"></i> SCMS
        </h4>
        <small class="text-muted">v3.0</small>
    </div>

    <!-- Navigation Menu -->
    <nav class="sidebar-nav p-3">
        <ul class="nav flex-column gap-1">
            <!-- Dashboard -->
            <li class="nav-item">
                <a href="<?php echo BASE_PATH; ?>dashboard.php" class="nav-link <?php echo ($current_page ?? '') === 'dashboard' ? 'active bg-primary text-white' : 'text-dark'; ?> rounded">
                    <i class="bi bi-speedometer2 me-2"></i> Dashboard
                </a>
            </li>

            <!-- Workers -->
            <li class="nav-item">
                <a href="<?php echo BASE_PATH; ?>workers.php" class="nav-link <?php echo ($current_page ?? '') === 'workers' ? 'active bg-primary text-white' : 'text-dark'; ?> rounded">
                    <i class="bi bi-people me-2"></i> Sponsored Workers
                </a>
            </li>

            <!-- Attendance -->
            <li class="nav-item">
                <a href="<?php echo BASE_PATH; ?>attendance.php" class="nav-link <?php echo ($current_page ?? '') === 'attendance' ? 'active bg-primary text-white' : 'text-dark'; ?> rounded">
                    <i class="bi bi-clock-history me-2"></i> Attendance
                </a>
            </li>

            <!-- Holidays -->
            <li class="nav-item">
                <a href="<?php echo BASE_PATH; ?>holidays.php" class="nav-link <?php echo ($current_page ?? '') === 'holidays' ? 'active bg-primary text-white' : 'text-dark'; ?> rounded">
                    <i class="bi bi-calendar-event me-2"></i> Holidays
                </a>
            </li>

            <!-- Documents -->
            <li class="nav-item">
                <a href="<?php echo BASE_PATH; ?>documents.php" class="nav-link <?php echo ($current_page ?? '') === 'documents' ? 'active bg-primary text-white' : 'text-dark'; ?> rounded">
                    <i class="bi bi-file-earmark-text me-2"></i> Documents
                </a>
            </li>

            <!-- Locations -->
            <li class="nav-item">
                <a href="<?php echo BASE_PATH; ?>locations.php" class="nav-link <?php echo ($current_page ?? '') === 'locations' ? 'active bg-primary text-white' : 'text-dark'; ?> rounded">
                    <i class="bi bi-geo-alt me-2"></i> Work Locations
                </a>
            </li>

            <!-- CoS Management -->
            <li class="nav-item">
                <a href="<?php echo BASE_PATH; ?>cos.php" class="nav-link <?php echo ($current_page ?? '') === 'cos' ? 'active bg-primary text-white' : 'text-dark'; ?> rounded">
                    <i class="bi bi-file-earmark-medical me-2"></i> CoS Management
                </a>
            </li>

            <li class="nav-item">
                <hr class="my-2">
            </li>

            <!-- Reports -->
            <li class="nav-item">
                <a href="<?php echo BASE_PATH; ?>reports.php" class="nav-link <?php echo ($current_page ?? '') === 'reports' ? 'active bg-primary text-white' : 'text-dark'; ?> rounded">
                    <i class="bi bi-file-earmark-bar-graph me-2"></i> Reports
                </a>
            </li>

            <!-- Home Office Reports -->
            <li class="nav-item">
                <a href="<?php echo BASE_PATH; ?>ho_reports.php" class="nav-link <?php echo ($current_page ?? '') === 'ho_reports' ? 'active bg-primary text-white' : 'text-dark'; ?> rounded">
                    <i class="bi bi-flag me-2"></i> Home Office Reports
                </a>
            </li>

            <li class="nav-item">
                <hr class="my-2">
            </li>

            <!-- Profile -->
            <li class="nav-item">
                <a href="<?php echo BASE_PATH; ?>profile.php" class="nav-link <?php echo ($current_page ?? '') === 'profile' ? 'active bg-primary text-white' : 'text-dark'; ?> rounded">
                    <i class="bi bi-person-circle me-2"></i> My Profile
                </a>
            </li>

            <!-- Users -->
            <li class="nav-item">
                <a href="<?php echo BASE_PATH; ?>users.php" class="nav-link <?php echo ($current_page ?? '') === 'users' ? 'active bg-primary text-white' : 'text-dark'; ?> rounded">
                    <i class="bi bi-person-badge me-2"></i> Users
                </a>
            </li>

            <!-- Settings -->
            <li class="nav-item">
                <a href="<?php echo BASE_PATH; ?>settings.php" class="nav-link <?php echo ($current_page ?? '') === 'settings' ? 'active bg-primary text-white' : 'text-dark'; ?> rounded">
                    <i class="bi bi-gear me-2"></i> Settings
                </a>
            </li>

            <!-- Audit Logs -->
            <li class="nav-item">
                <a href="<?php echo BASE_PATH; ?>audit.php" class="nav-link <?php echo ($current_page ?? '') === 'audit' ? 'active bg-primary text-white' : 'text-dark'; ?> rounded">
                    <i class="bi bi-journal-text me-2"></i> Audit Logs
                </a>
            </li>
        </ul>
    </nav>

    <!-- System Status Footer -->
    <div class="sidebar-footer p-3 border-top mt-auto" style="position: absolute; bottom: 0; width: 100%; background: white;">
        <div class="small text-muted">
            <div class="d-flex align-items-center justify-content-between mb-1">
                <span><i class="bi bi-shield-check text-success"></i> System Status</span>
                <span class="badge bg-success">Active</span>
            </div>
            <div class="text-muted" style="font-size: 0.75rem;">
                License: <?php echo ucfirst($capacity['license_type'] ?? 'Unknown'); ?>
            </div>
        </div>
    </div>
</aside>

<style>
    .sidebar .nav-link {
        padding: 0.75rem 1rem;
        transition: all 0.2s;
        font-size: 0.95rem;
    }

    .sidebar .nav-link:hover:not(.active) {
        background-color: #f8f9fa;
        transform: translateX(4px);
    }

    .sidebar .nav-link.active {
        font-weight: 500;
    }

    .sidebar .nav-link i {
        width: 20px;
        text-align: center;
    }

    @media (max-width: 768px) {
        #sidebar {
            transform: translateX(-100%);
        }

        #sidebar.show {
            transform: translateX(0);
        }
    }

    .sidebar::-webkit-scrollbar {
        width: 6px;
    }

    .sidebar::-webkit-scrollbar-track {
        background: #f1f1f1;
    }

    .sidebar::-webkit-scrollbar-thumb {
        background: #888;
        border-radius: 3px;
    }

    .sidebar::-webkit-scrollbar-thumb:hover {
        background: #555;
    }
</style>
