<?php
/**
 * Settings Tools Tab - Diagnostic and Maintenance Tools
 * Included in settings.php when tab=tools
 */

// Ensure this file is only included from settings.php
if (!defined('SETTINGS_PAGE')) {
    die('Direct access not permitted');
}
?>

<!-- Tools Tab -->
<div class="modern-card">
    <div class="card-header-modern">
        <h5 class="card-title-modern mb-0">
            <i class="bi bi-tools"></i> System Tools & Diagnostics
        </h5>
    </div>
    <div class="card-body-modern">
        <p class="text-muted mb-4">
            Diagnostic and maintenance tools to help troubleshoot and maintain your SCMS system.
        </p>

        <!-- Tools Grid -->
        <div class="row g-4">

            <!-- Attendance Tools -->
            <div class="col-12">
                <h6 class="text-primary mb-3">
                    <i class="bi bi-calendar-check"></i> Attendance Module Tools
                </h6>
            </div>

            <!-- Check Today's Attendance -->
            <div class="col-md-6 col-lg-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-3">
                            <div class="flex-shrink-0">
                                <div class="bg-primary bg-opacity-10 rounded p-3">
                                    <i class="bi bi-calendar-day text-primary" style="font-size: 1.5rem;"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <h6 class="mb-0">Check Today's Attendance</h6>
                                <small class="text-muted">View all attendance records for today</small>
                            </div>
                        </div>
                        <p class="small text-muted mb-3">
                            Shows detailed list of all workers with attendance marked today, including their status and department.
                        </p>
                        <a href="/sys/scms/modules/attendance/check_today.php" class="btn btn-sm btn-outline-primary w-100" target="_blank">
                            <i class="bi bi-box-arrow-up-right"></i> Open Tool
                        </a>
                    </div>
                </div>
            </div>

            <!-- Check Worker Attendance -->
            <div class="col-md-6 col-lg-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-3">
                            <div class="flex-shrink-0">
                                <div class="bg-success bg-opacity-10 rounded p-3">
                                    <i class="bi bi-person-check text-success" style="font-size: 1.5rem;"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <h6 class="mb-0">Check Worker Records</h6>
                                <small class="text-muted">View specific worker's attendance</small>
                            </div>
                        </div>
                        <p class="small text-muted mb-3">
                            Display all attendance records for a specific worker, useful for debugging duplicate records.
                        </p>
                        <a href="/sys/scms/modules/attendance/check_worker.php" class="btn btn-sm btn-outline-success w-100" target="_blank">
                            <i class="bi bi-box-arrow-up-right"></i> Open Tool
                        </a>
                    </div>
                </div>
            </div>

            <!-- Check Attendance Dates -->
            <div class="col-md-6 col-lg-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-3">
                            <div class="flex-shrink-0">
                                <div class="bg-info bg-opacity-10 rounded p-3">
                                    <i class="bi bi-calendar-range text-info" style="font-size: 1.5rem;"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <h6 class="mb-0">Check Date Records</h6>
                                <small class="text-muted">View attendance by date range</small>
                            </div>
                        </div>
                        <p class="small text-muted mb-3">
                            Check attendance records for specific dates or date ranges to verify data integrity.
                        </p>
                        <a href="/sys/scms/modules/attendance/check_dates.php" class="btn btn-sm btn-outline-info w-100" target="_blank">
                            <i class="bi bi-box-arrow-up-right"></i> Open Tool
                        </a>
                    </div>
                </div>
            </div>

            <!-- Cleanup Deleted Workers -->
            <div class="col-md-6 col-lg-4">
                <div class="card h-100 border-0 shadow-sm border-warning">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-3">
                            <div class="flex-shrink-0">
                                <div class="bg-warning bg-opacity-10 rounded p-3">
                                    <i class="bi bi-trash text-warning" style="font-size: 1.5rem;"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <h6 class="mb-0">Cleanup Deleted Workers</h6>
                                <small class="text-muted">Remove old attendance data</small>
                            </div>
                        </div>
                        <p class="small text-muted mb-3">
                            <strong>⚠️ Caution:</strong> Permanently deletes attendance records for deleted workers. Use only if needed.
                        </p>
                        <a href="/sys/scms/modules/attendance/cleanup_deleted_workers.php" class="btn btn-sm btn-outline-warning w-100" target="_blank">
                            <i class="bi bi-exclamation-triangle"></i> Open Cleanup Tool
                        </a>
                    </div>
                </div>
            </div>

            <!-- Database Tools -->
            <div class="col-12 mt-5">
                <h6 class="text-primary mb-3">
                    <i class="bi bi-database"></i> Database & System Tools
                </h6>
            </div>

            <!-- PHPInfo -->
            <div class="col-md-6 col-lg-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-3">
                            <div class="flex-shrink-0">
                                <div class="bg-secondary bg-opacity-10 rounded p-3">
                                    <i class="bi bi-info-circle text-secondary" style="font-size: 1.5rem;"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <h6 class="mb-0">PHP Information</h6>
                                <small class="text-muted">System configuration details</small>
                            </div>
                        </div>
                        <p class="small text-muted mb-3">
                            Display PHP version, loaded extensions, configuration settings, and server information.
                        </p>
                        <button onclick="window.open('/sys/scms/phpinfo.php', '_blank')" class="btn btn-sm btn-outline-secondary w-100">
                            <i class="bi bi-box-arrow-up-right"></i> View PHP Info
                        </button>
                    </div>
                </div>
            </div>

            <!-- Cache Clear -->
            <div class="col-md-6 col-lg-4">
                <div class="card h-100 border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-3">
                            <div class="flex-shrink-0">
                                <div class="bg-danger bg-opacity-10 rounded p-3">
                                    <i class="bi bi-arrow-clockwise text-danger" style="font-size: 1.5rem;"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <h6 class="mb-0">Clear Browser Cache</h6>
                                <small class="text-muted">Force refresh resources</small>
                            </div>
                        </div>
                        <p class="small text-muted mb-3">
                            Instructions to clear browser cache and force reload CSS/JS files after updates.
                        </p>
                        <button onclick="showCacheInstructions()" class="btn btn-sm btn-outline-danger w-100">
                            <i class="bi bi-question-circle"></i> Show Instructions
                        </button>
                    </div>
                </div>
            </div>

        </div>

        <!-- Cache Instructions Modal -->
        <div class="modal fade" id="cacheInstructionsModal" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">
                            <i class="bi bi-arrow-clockwise"></i> Clear Browser Cache
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <h6>Windows / Linux:</h6>
                        <ul>
                            <li><strong>Chrome / Edge:</strong> Ctrl + Shift + R or Ctrl + F5</li>
                            <li><strong>Firefox:</strong> Ctrl + Shift + R or Ctrl + F5</li>
                            <li><strong>Complete Clear:</strong> Ctrl + Shift + Delete</li>
                        </ul>
                        <h6>Mac:</h6>
                        <ul>
                            <li><strong>Chrome / Edge:</strong> Cmd + Shift + R</li>
                            <li><strong>Firefox:</strong> Cmd + Shift + R</li>
                            <li><strong>Safari:</strong> Cmd + Option + E</li>
                        </ul>
                        <div class="alert alert-info mt-3">
                            <i class="bi bi-info-circle"></i> Hard refresh will reload all CSS, JavaScript, and images without using cached versions.
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<script>
function showCacheInstructions() {
    const modal = new bootstrap.Modal(document.getElementById('cacheInstructionsModal'));
    modal.show();
}
</script>
