<?php
/**
 * Comprehensive list of nationalities for UK immigration purposes
 * Grouped by region and immigration category
 */

// EU/EEA countries (eligible for EU Settlement Scheme)
$eu_eea_countries = [
    'Austrian', 'Belgian', 'Bulgarian', 'Croatian', 'Cypriot', 'Czech', 'Danish', 'Dutch',
    'Estonian', 'Finnish', 'French', 'German', 'Greek', 'Hungarian', 'Irish', 'Italian',
    'Latvian', 'Lithuanian', 'Luxembourgish', 'Maltese', 'Polish', 'Portuguese', 'Romanian',
    'Slovak', 'Slovenian', 'Spanish', 'Swedish',
    'Icelandic', 'Liechtenstein', 'Norwegian', 'Swiss'
];

// Full nationality list
$all_nationalities = [
    // British Isles
    'British', 'Irish',

    // EU/EEA (alphabetical)
    'Austrian', 'Belgian', 'Bulgarian', 'Croatian', 'Cypriot', 'Czech', 'Danish', 'Dutch',
    'Estonian', 'Finnish', 'French', 'German', 'Greek', 'Hungarian', 'Italian',
    'Latvian', 'Lithuanian', 'Luxembourgish', 'Maltese', 'Polish', 'Portuguese', 'Romanian',
    'Slovak', 'Slovenian', 'Spanish', 'Swedish',
    'Icelandic', 'Liechtenstein', 'Norwegian', 'Swiss',

    // Europe (Non-EU)
    'Albanian', 'Andorran', 'Armenian', 'Azerbaijani', 'Belarusian', 'Bosnian',
    'Georgian', 'Kosovar', 'Macedonian', 'Moldovan', 'Montenegrin', 'Russian',
    'San Marinese', 'Serbian', 'Turkish', 'Ukrainian', 'Vatican',

    // Asia
    'Afghan', 'Bangladeshi', 'Bhutanese', 'Bruneian', 'Burmese', 'Cambodian',
    'Chinese', 'Filipino', 'Indian', 'Indonesian', 'Japanese', 'Kazakh', 'Kyrgyz',
    'Laotian', 'Malaysian', 'Maldivian', 'Mongolian', 'Nepalese', 'North Korean',
    'Pakistani', 'Singaporean', 'South Korean', 'Sri Lankan', 'Taiwanese', 'Tajik',
    'Thai', 'Timorese', 'Turkmen', 'Uzbek', 'Vietnamese',

    // Middle East
    'Bahraini', 'Emirati', 'Iranian', 'Iraqi', 'Israeli', 'Jordanian', 'Kuwaiti',
    'Lebanese', 'Omani', 'Palestinian', 'Qatari', 'Saudi Arabian', 'Syrian', 'Yemeni',

    // Africa
    'Algerian', 'Angolan', 'Beninese', 'Botswanan', 'Burkinabe', 'Burundian',
    'Cameroonian', 'Cape Verdean', 'Central African', 'Chadian', 'Comorian',
    'Congolese', 'Djiboutian', 'Egyptian', 'Equatorial Guinean', 'Eritrean',
    'Eswatini', 'Ethiopian', 'Gabonese', 'Gambian', 'Ghanaian', 'Guinean',
    'Guinean-Bissauan', 'Ivorian', 'Kenyan', 'Lesotho', 'Liberian', 'Libyan',
    'Malagasy', 'Malawian', 'Malian', 'Mauritanian', 'Mauritian', 'Moroccan',
    'Mozambican', 'Namibian', 'Nigerian', 'Nigerien', 'Rwandan',
    'Sao Tomean', 'Senegalese', 'Seychellois', 'Sierra Leonean', 'Somali',
    'South African', 'South Sudanese', 'Sudanese', 'Tanzanian', 'Togolese',
    'Tunisian', 'Ugandan', 'Zambian', 'Zimbabwean',

    // Americas
    'American', 'Antiguan', 'Argentine', 'Bahamian', 'Barbadian', 'Belizean',
    'Bolivian', 'Brazilian', 'Canadian', 'Chilean', 'Colombian', 'Costa Rican',
    'Cuban', 'Dominican', 'Ecuadorian', 'Salvadoran', 'Grenadian', 'Guatemalan',
    'Guyanese', 'Haitian', 'Honduran', 'Jamaican', 'Mexican', 'Nicaraguan',
    'Panamanian', 'Paraguayan', 'Peruvian', 'Saint Lucian', 'Surinamese',
    'Trinidadian', 'Uruguayan', 'Venezuelan',

    // Oceania
    'Australian', 'Fijian', 'Kiribati', 'Marshallese', 'Micronesian', 'Nauruan',
    'New Zealand', 'Palauan', 'Papua New Guinean', 'Samoan', 'Solomon Islander',
    'Tongan', 'Tuvaluan', 'Vanuatuan'
];

// Sort alphabetically for display
sort($all_nationalities);

return [
    'all' => $all_nationalities,
    'eu_eea' => $eu_eea_countries,
    'no_visa_required' => ['British', 'Irish']
];
?>
