<?php
// Load global routes configuration
if (!defined('BASE_PATH')) {
    if (file_exists(__DIR__ . '/../config/routes.php')) {
        require_once __DIR__ . '/../config/routes.php';
    } else {
        define('BASE_PATH', '/sys/scms/');
    }
}
?>
<!DOCTYPE html>
<html lang="en" data-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? htmlspecialchars($page_title) . ' - ' : ''; ?>SCMS v3.0</title>

    <!-- Bootstrap CSS - Latest Version 5.3.3 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">

    <!-- Bootstrap Icons - Latest Version 1.11.3 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

    <!-- Material Icons -->
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@20..48,100..700,0..1,-50..200" rel="stylesheet">

    <!-- Font Awesome 6 -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" />

    <!-- Remix Icons -->
    <link href="https://cdn.jsdelivr.net/npm/remixicon@4.0.0/fonts/remixicon.css" rel="stylesheet">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

    <!-- SCMS Professional Styles -->
    <link href="<?php echo BASE_PATH; ?>assets/css/scms-professional.css" rel="stylesheet">

    <!-- Moment.js - Date/Time Formatting (British Locale) -->
    <script src="https://cdn.jsdelivr.net/npm/moment@2.29.4/moment.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/moment@2.29.4/locale/en-gb.js"></script>

    <!-- Numeral.js - Number Formatting (British Format) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/numeral.js/2.0.6/numeral.min.js"></script>

    <!-- Initialize Localization -->
    <script>
        // Set global locale configuration
        window.SCMS_LOCALE = <?php echo json_encode(get_locale_config()); ?>;

        // Configure Moment.js for British English
        moment.locale('en-gb', {
            week: {
                dow: 1, // Monday is the first day of the week
                doy: 4  // Used to determine first week of the year
            }
        });

        // Configure Numeral.js for British format
        numeral.register('locale', 'en-gb', {
            delimiters: {
                thousands: ',',
                decimal: '.'
            },
            abbreviations: {
                thousand: 'k',
                million: 'm',
                billion: 'b',
                trillion: 't'
            },
            currency: {
                symbol: '£'
            }
        });
        numeral.locale('en-gb');

        // Helper functions for formatting
        window.formatDate = function(date, format) {
            format = format || 'DD/MM/YYYY';
            return moment(date).format(format);
        };

        window.formatDateTime = function(date) {
            return moment(date).format('DD/MM/YYYY HH:mm');
        };

        window.formatTime = function(date, use12h) {
            return moment(date).format(use12h ? 'h:mm A' : 'HH:mm');
        };

        window.formatCurrency = function(amount) {
            return numeral(amount).format('£0,0.00');
        };

        window.formatNumber = function(number, decimals) {
            decimals = decimals !== undefined ? decimals : 2;
            return numeral(number).format('0,0.' + '0'.repeat(decimals));
        };
    </script>

    <!-- Custom Modern CSS with Dark Mode -->
    <style>
        :root[data-theme="light"] {
            --bg-primary: #ffffff;
            --bg-secondary: #f7f9fc;
            --bg-tertiary: #f1f4f9;
            --text-primary: #2d3748;
            --text-secondary: #64748b;
            --text-muted: #94a3b8;
            --border-color: #e2e8f0;
            --shadow: rgba(100, 116, 139, 0.08);
            --shadow-lg: rgba(100, 116, 139, 0.12);
            --sidebar-bg: #ffffff;
            --sidebar-text: #64748b;
            --sidebar-active: #6366f1;
            --sidebar-hover: #f8fafc;
            --card-bg: #ffffff;
            --navbar-bg: #ffffff;
            --accent-primary: #6366f1;
            --accent-primary-hover: #4f46e5;
            --accent-secondary: #8b5cf6;
            --accent-success: #10b981;
            --accent-success-hover: #059669;
            --accent-warning: #f59e0b;
            --accent-warning-hover: #d97706;
            --accent-danger: #ef4444;
            --accent-danger-hover: #dc2626;
            --accent-info: #3b82f6;
            --accent-info-hover: #2563eb;
            --table-header-bg: #f8fafc;
            --table-row-hover: #f1f5f9;
        }

        :root[data-theme="dark"] {
            --bg-primary: #2b2d31;
            --bg-secondary: #1e1f22;
            --bg-tertiary: #313338;
            --text-primary: #f2f3f5;
            --text-secondary: #b5bac1;
            --text-muted: #80848e;
            --border-color: #3f4147;
            --shadow: rgba(0, 0, 0, 0.4);
            --shadow-lg: rgba(0, 0, 0, 0.6);
            --sidebar-bg: #2b2d31;
            --sidebar-text: #b5bac1;
            --sidebar-active: #5865f2;
            --sidebar-hover: #35373c;
            --card-bg: #2b2d31;
            --navbar-bg: #2b2d31;
            --input-bg: #1e1f22;
            --input-border: #3f4147;
            --input-text: #f2f3f5;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
            background: var(--bg-secondary);
            color: var(--text-primary);
            transition: background-color 0.3s ease, color 0.3s ease;
            overflow-x: hidden;
        }

        /* Sidebar Styles */
        .sidebar {
            position: fixed;
            left: 0;
            top: 0;
            bottom: 0;
            width: 280px;
            background: var(--sidebar-bg);
            border-right: 1px solid var(--border-color);
            padding: 1.5rem 0;
            overflow-y: auto;
            overflow-x: hidden;
            z-index: 1000;
            transition: all 0.3s ease;
            scrollbar-width: none; /* Firefox */
            -ms-overflow-style: none; /* IE and Edge */
        }

        /* Hide scrollbar for Chrome, Safari and Opera */
        .sidebar::-webkit-scrollbar {
            display: none;
        }

        /* Collapsed sidebar */
        .sidebar.collapsed {
            width: 80px;
        }

        .sidebar.collapsed .sidebar-text-content,
        .sidebar.collapsed .nav-section-title,
        .sidebar.collapsed .nav-link span {
            opacity: 0;
            width: 0;
            overflow: hidden;
        }

        .sidebar.collapsed .sidebar-collapse-btn {
            width: 100%;
            margin: 0;
            border-radius: 0;
        }

        .sidebar.collapsed .sidebar-collapse-btn i {
            transform: rotate(180deg);
        }

        .sidebar.collapsed .sidebar-header {
            padding: 0 0 1rem;
            flex-direction: column;
            gap: 0.5rem;
        }

        .sidebar.collapsed .sidebar-logo-link {
            width: 100%;
            justify-content: center;
        }

        .sidebar.collapsed .nav-link {
            justify-content: center;
            padding: 0.75rem 0.5rem;
        }

        .sidebar-header {
            padding: 0 1.5rem 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
            border-bottom: 1px solid var(--border-color);
            margin-bottom: 1.5rem;
        }

        .sidebar-logo-link {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            text-decoration: none;
            transition: all 0.2s ease;
        }

        .sidebar-logo-link:hover {
            transform: scale(1.02);
        }

        .sidebar-logo {
            width: 40px;
            height: 40px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 1.25rem;
            font-weight: 700;
        }

        .sidebar-title {
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--text-primary);
        }

        .sidebar-version {
            font-size: 0.75rem;
            color: var(--text-muted);
        }

        .sidebar-text-content {
            transition: all 0.3s ease;
        }

        .sidebar-collapse-btn {
            width: 32px;
            height: 32px;
            border-radius: 8px;
            border: none;
            background: var(--bg-secondary);
            color: var(--text-primary);
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.2s ease;
            margin-left: auto;
        }

        .sidebar-collapse-btn:hover {
            background: var(--sidebar-hover);
            color: var(--sidebar-active);
        }

        .sidebar-collapse-btn i {
            transition: transform 0.3s ease;
        }

        .sidebar-nav {
            padding: 0 1rem;
            display: flex;
            flex-direction: column;
            flex: 1;
            overflow-y: auto;
        }

        .nav-section-title {
            font-size: 0.75rem;
            font-weight: 600;
            color: var(--text-muted);
            text-transform: uppercase;
            letter-spacing: 0.05em;
            padding: 0.75rem 0.75rem 0.5rem;
        }

        .nav-link {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.75rem;
            margin: 0.25rem 0;
            border-radius: 10px;
            color: var(--sidebar-text);
            text-decoration: none;
            font-weight: 500;
            font-size: 0.95rem;
            transition: all 0.2s ease;
            position: relative;
        }

        .nav-link i {
            font-size: 1.1rem;
            width: 20px;
        }

        .nav-link:hover {
            background: var(--sidebar-hover);
            color: var(--sidebar-active);
            transform: translateX(3px);
        }

        .nav-link.active {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }

        .nav-link.active i {
            color: white;
        }

        /* Top Navbar */
        .top-navbar {
            position: fixed;
            top: 0;
            left: 280px;
            right: 0;
            height: 70px;
            background: var(--navbar-bg);
            border-bottom: 1px solid var(--border-color);
            padding: 0 2rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
            z-index: 999;
            transition: all 0.3s ease;
        }

        .sidebar.collapsed ~ .top-navbar {
            left: 80px;
        }

        .navbar-search {
            flex: 1;
            max-width: 500px;
            position: relative;
        }

        .navbar-search input {
            width: 100%;
            padding: 0.75rem 1rem 0.75rem 2.75rem;
            border-radius: 12px;
            border: 1px solid var(--border-color);
            background: var(--bg-secondary);
            color: var(--text-primary);
            font-size: 0.95rem;
            transition: all 0.2s ease;
        }

        .navbar-search input:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .navbar-search i {
            position: absolute;
            left: 1rem;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-muted);
        }

        .navbar-actions {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .theme-toggle {
            width: 40px;
            height: 40px;
            border-radius: 10px;
            border: none;
            background: var(--bg-secondary);
            color: var(--text-primary);
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .theme-toggle:hover {
            background: var(--sidebar-hover);
            transform: scale(1.05);
        }

        .notifications-btn {
            position: relative;
            width: 40px;
            height: 40px;
            border-radius: 10px;
            border: none;
            background: var(--bg-secondary);
            color: var(--text-primary);
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .notifications-btn:hover {
            background: var(--sidebar-hover);
        }

        .notification-badge {
            position: absolute;
            top: -4px;
            right: -4px;
            width: 18px;
            height: 18px;
            border-radius: 50%;
            background: #ef4444;
            color: white;
            font-size: 0.7rem;
            font-weight: 600;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .user-menu {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.5rem 0.75rem;
            border-radius: 12px;
            background: var(--bg-secondary);
            border: none;
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .user-menu:hover {
            background: var(--sidebar-hover);
        }

        .dropdown-menu {
            box-shadow: 0 8px 24px var(--shadow-lg);
            border: 1px solid var(--border-color);
            border-radius: 12px;
            padding: 0.5rem;
        }

        .dropdown-item {
            border-radius: 8px;
            padding: 0.5rem 1rem;
            transition: all 0.2s ease;
        }

        .dropdown-item:hover {
            background: var(--sidebar-hover);
        }

        .dropdown-item i {
            width: 20px;
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 10px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
            font-size: 0.9rem;
        }

        .user-info {
            display: flex;
            flex-direction: column;
            align-items: flex-start;
            text-align: left;
        }

        .user-name {
            font-weight: 600;
            font-size: 0.9rem;
            color: var(--text-primary);
            line-height: 1.2;
        }

        .user-role {
            font-size: 0.75rem;
            color: var(--text-muted);
            line-height: 1.2;
        }

        /* Main Content */
        .main-content {
            margin-left: 280px;
            margin-top: 70px;
            padding: 2rem;
            min-height: calc(100vh - 70px);
            transition: all 0.3s ease;
        }

        .sidebar.collapsed ~ * .main-content,
        body.sidebar-collapsed .main-content {
            margin-left: 80px;
        }

        .dashboard-container {
            max-width: 1400px;
            margin: 0 auto;
        }

        /* Welcome Section */
        .welcome-section {
            background: var(--card-bg);
            border-radius: 20px;
            padding: 2rem;
            margin-bottom: 2rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border: 1px solid var(--border-color);
            position: relative;
            overflow: hidden;
        }

        .welcome-section::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 400px;
            height: 100%;
            background: linear-gradient(135deg, rgba(102, 126, 234, 0.1) 0%, rgba(118, 75, 162, 0.1) 100%);
            border-radius: 50%;
            transform: translate(30%, -30%);
        }

        .welcome-content {
            position: relative;
            z-index: 1;
        }

        .welcome-actions {
            position: relative;
            z-index: 1;
        }

        .incomplete-tab {
            background-color: rgba(220, 53, 69, 0.1) !important;
            border-left: 3px solid #dc3545 !important;
        }

        .incomplete-tab:hover {
            background-color: rgba(220, 53, 69, 0.15) !important;
        }

        .missing-field-row {
            border-left: 3px solid #dc3545;
            background-color: rgba(220, 53, 69, 0.03);
            padding: 10px;
            border-radius: 4px;
            margin-bottom: 10px;
        }

        .missing-field-label {
            color: #dc3545 !important;
            font-weight: 600 !important;
        }

        .missing-field-label::after {
            content: " ⚠ Required";
            font-size: 0.85em;
            font-weight: 500;
        }

        .edit-icon-btn {
            cursor: pointer;
            color: #6c757d;
            transition: color 0.2s;
        }

        .edit-icon-btn:hover {
            color: #0d6efd;
        }

        .welcome-title {
            font-size: 1.75rem;
            font-weight: 700;
            color: var(--text-primary);
            margin-bottom: 0.5rem;
        }

        .welcome-subtitle {
            color: var(--text-secondary);
            font-size: 1rem;
            margin: 0;
        }

        .system-status-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.75rem 1.25rem;
            background: rgba(34, 197, 94, 0.1);
            color: #22c55e;
            border-radius: 50px;
            font-weight: 600;
            font-size: 0.9rem;
        }

        .pulse {
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.5; }
        }

        /* Statistics Grid */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }

        .stat-card {
            background: var(--card-bg);
            border-radius: 20px;
            padding: 1.75rem;
            border: 1px solid var(--border-color);
            position: relative;
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .stat-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 12px 24px var(--shadow-lg);
        }

        /* Glare effect on hover */
        .stat-card::after {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            transition: left 0.5s ease;
        }

        .stat-card:hover::after {
            left: 100%;
        }

        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
        }

        .gradient-blue::before { background: linear-gradient(90deg, #667eea 0%, #764ba2 100%); }
        .gradient-green::before { background: linear-gradient(90deg, #10b981 0%, #22c55e 100%); }
        .gradient-yellow::before { background: linear-gradient(90deg, #f59e0b 0%, #fbbf24 100%); }
        .gradient-red::before { background: linear-gradient(90deg, #ef4444 0%, #f87171 100%); }
        .gradient-purple::before { background: linear-gradient(90deg, #8b5cf6 0%, #a78bfa 100%); }
        .gradient-orange::before { background: linear-gradient(90deg, #f59e0b 0%, #fb923c 100%); }
        .gradient-cyan::before { background: linear-gradient(90deg, #06b6d4 0%, #22d3ee 100%); }
        .gradient-pink::before { background: linear-gradient(90deg, #ec4899 0%, #f472b6 100%); }

        .stat-icon {
            width: 60px;
            height: 60px;
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.75rem;
            margin-bottom: 1rem;
            color: white;
        }

        .gradient-blue .stat-icon { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
        .gradient-green .stat-icon { background: linear-gradient(135deg, #10b981 0%, #22c55e 100%); }
        .gradient-yellow .stat-icon { background: linear-gradient(135deg, #f59e0b 0%, #fbbf24 100%); }
        .gradient-red .stat-icon { background: linear-gradient(135deg, #ef4444 0%, #f87171 100%); }
        .gradient-purple .stat-icon { background: linear-gradient(135deg, #8b5cf6 0%, #a78bfa 100%); }
        .gradient-orange .stat-icon { background: linear-gradient(135deg, #f59e0b 0%, #fb923c 100%); }
        .gradient-cyan .stat-icon { background: linear-gradient(135deg, #06b6d4 0%, #22d3ee 100%); }
        .gradient-pink .stat-icon { background: linear-gradient(135deg, #ec4899 0%, #f472b6 100%); }

        .stat-value {
            font-size: 2.25rem;
            font-weight: 700;
            color: var(--text-primary);
            margin-bottom: 0.25rem;
        }

        .stat-label {
            color: var(--text-secondary);
            font-size: 0.95rem;
            font-weight: 500;
            margin-bottom: 1rem;
        }

        .stat-footer {
            padding-top: 1rem;
            border-top: 1px solid var(--border-color);
        }

        .stat-link {
            color: var(--sidebar-active);
            text-decoration: none;
            font-weight: 600;
            font-size: 0.9rem;
            transition: all 0.2s ease;
        }

        .stat-link:hover {
            gap: 0.5rem;
        }

        .stat-background {
            position: absolute;
            bottom: -20px;
            right: -20px;
            font-size: 120px;
            opacity: 0.05;
        }

        /* Modern Cards */
        .modern-card {
            background: var(--card-bg);
            border-radius: 20px;
            border: 1px solid var(--border-color);
            margin-bottom: 2rem;
            overflow: hidden;
        }

        .card-header-modern {
            padding: 1.5rem 2rem;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .card-title-modern {
            font-size: 1.15rem;
            font-weight: 700;
            color: var(--text-primary);
            margin: 0;
        }

        .card-subtitle-modern {
            font-size: 0.85rem;
            color: var(--text-muted);
            margin: 0.25rem 0 0;
        }

        .card-body-modern {
            padding: 2rem;
        }

        .card-footer-modern {
            padding: 1.5rem 2rem;
            border-top: 1px solid var(--border-color);
        }

        /* Capacity Badge */
        .capacity-badge {
            padding: 0.5rem 1rem;
            border-radius: 50px;
            font-weight: 600;
            font-size: 0.85rem;
        }

        .badge-success {
            background: rgba(34, 197, 94, 0.1);
            color: #22c55e;
        }

        .badge-warning {
            background: rgba(245, 158, 11, 0.1);
            color: #f59e0b;
        }

        .badge-danger {
            background: rgba(239, 68, 68, 0.1);
            color: #ef4444;
        }

        /* Modern Progress */
        .modern-progress {
            margin: 2rem 0;
        }

        .progress-track {
            height: 12px;
            background: var(--bg-secondary);
            border-radius: 50px;
            overflow: hidden;
            position: relative;
        }

        .progress-fill {
            height: 100%;
            border-radius: 50px;
            position: relative;
            transition: width 1s ease;
            display: flex;
            align-items: center;
            justify-content: flex-end;
            padding-right: 0.5rem;
        }

        .progress-success { background: linear-gradient(90deg, #10b981 0%, #22c55e 100%); }
        .progress-warning { background: linear-gradient(90deg, #f59e0b 0%, #fbbf24 100%); }
        .progress-danger { background: linear-gradient(90deg, #ef4444 0%, #f87171 100%); }

        .progress-label {
            color: white;
            font-size: 0.75rem;
            font-weight: 600;
        }

        .capacity-info {
            margin-bottom: 1.5rem;
        }

        .capacity-stats {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 1rem;
        }

        .capacity-stat {
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .capacity-number {
            font-size: 2rem;
            font-weight: 700;
            color: var(--text-primary);
        }

        .capacity-text {
            font-size: 0.85rem;
            color: var(--text-muted);
        }

        .capacity-divider {
            font-size: 2rem;
            color: var(--text-muted);
            font-weight: 300;
        }

        .license-info {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 1.5rem;
            padding-top: 1.5rem;
            border-top: 1px solid var(--border-color);
        }

        .license-type {
            color: var(--text-secondary);
            font-size: 0.9rem;
        }

        .license-warning {
            color: #ef4444;
            font-size: 0.85rem;
            font-weight: 600;
        }

        /* Attendance Card */
        .attendance-number {
            padding: 2rem 0;
        }

        .attendance-value {
            font-size: 3.5rem;
            font-weight: 700;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 0.5rem;
        }

        .attendance-label {
            color: var(--text-muted);
            font-size: 0.95rem;
            margin: 0;
        }

        /* Quick Actions */
        .quick-actions-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1rem;
        }

        .quick-action-btn {
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 1.5rem;
            border-radius: 15px;
            text-decoration: none;
            color: white;
            font-weight: 600;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        /* Glare effect for quick action buttons */
        .quick-action-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            transition: left 0.5s ease;
            z-index: 1;
        }

        .quick-action-btn:hover::before {
            left: 100%;
        }

        .quick-action-btn:hover {
            transform: translateY(-4px);
            box-shadow: 0 12px 24px var(--shadow-lg);
        }

        .quick-action-btn > * {
            position: relative;
            z-index: 2;
        }

        .gradient-blue.quick-action-btn { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
        .gradient-green.quick-action-btn { background: linear-gradient(135deg, #10b981 0%, #22c55e 100%); }
        .gradient-purple.quick-action-btn { background: linear-gradient(135deg, #8b5cf6 0%, #a78bfa 100%); }
        .gradient-orange.quick-action-btn { background: linear-gradient(135deg, #f59e0b 0%, #fb923c 100%); }
        .gradient-cyan.quick-action-btn { background: linear-gradient(135deg, #06b6d4 0%, #22d3ee 100%); }
        .gradient-pink.quick-action-btn { background: linear-gradient(135deg, #ec4899 0%, #f472b6 100%); }
        .gradient-yellow.quick-action-btn { background: linear-gradient(135deg, #f59e0b 0%, #fbbf24 100%); }
        .gradient-red.quick-action-btn { background: linear-gradient(135deg, #ef4444 0%, #f87171 100%); }

        .quick-action-icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            background: rgba(255, 255, 255, 0.2);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
        }

        .quick-action-label {
            flex: 1;
            font-size: 1rem;
        }

        .quick-action-arrow {
            font-size: 1.25rem;
            opacity: 0.7;
        }

        /* Button Styles */
        .btn-modern-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            color: white;
            padding: 0.75rem 1.5rem;
            border-radius: 12px;
            font-weight: 600;
            font-size: 0.95rem;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.2s ease;
        }

        .btn-modern-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 16px rgba(102, 126, 234, 0.3);
            color: white;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }

            .sidebar.active {
                transform: translateX(0);
            }

            .top-navbar {
                left: 0;
            }

            .main-content {
                margin-left: 0;
            }

            .navbar-search {
                display: none;
            }

            .welcome-section {
                flex-direction: column;
                text-align: center;
                gap: 1rem;
            }

            .stats-grid {
                grid-template-columns: 1fr;
            }

            .quick-actions-grid {
                grid-template-columns: 1fr;
            }
        }

        /* Modern Alert */
        .modern-alert {
            border-radius: 15px;
            border: none;
            box-shadow: 0 4px 12px var(--shadow);
        }

        /* Dark Mode Form Controls */
        [data-theme="dark"] .form-control,
        [data-theme="dark"] .form-select,
        [data-theme="dark"] input[type="text"],
        [data-theme="dark"] input[type="email"],
        [data-theme="dark"] input[type="password"],
        [data-theme="dark"] input[type="number"],
        [data-theme="dark"] input[type="date"],
        [data-theme="dark"] input[type="time"],
        [data-theme="dark"] input[type="tel"],
        [data-theme="dark"] input[type="url"],
        [data-theme="dark"] textarea,
        [data-theme="dark"] select {
            background-color: var(--input-bg) !important;
            border-color: var(--input-border) !important;
            color: var(--input-text) !important;
        }

        [data-theme="dark"] .form-control:focus,
        [data-theme="dark"] .form-select:focus,
        [data-theme="dark"] input:focus,
        [data-theme="dark"] textarea:focus,
        [data-theme="dark"] select:focus {
            background-color: var(--input-bg) !important;
            border-color: #5865f2 !important;
            color: var(--input-text) !important;
            box-shadow: 0 0 0 0.25rem rgba(88, 101, 242, 0.25) !important;
        }

        [data-theme="dark"] .form-control::placeholder,
        [data-theme="dark"] input::placeholder,
        [data-theme="dark"] textarea::placeholder {
            color: var(--text-muted) !important;
            opacity: 0.6;
        }

        [data-theme="dark"] .form-label,
        [data-theme="dark"] label {
            color: var(--text-secondary) !important;
        }

        [data-theme="dark"] .table {
            color: var(--text-primary);
            border-color: var(--border-color);
        }

        [data-theme="dark"] .table thead {
            background-color: var(--bg-tertiary);
            border-color: var(--border-color);
        }

        [data-theme="dark"] .table tbody tr {
            border-color: var(--border-color);
        }

        [data-theme="dark"] .table tbody tr:hover {
            background-color: var(--sidebar-hover);
        }

        [data-theme="dark"] .dropdown-menu {
            background-color: var(--card-bg);
            border-color: var(--border-color);
        }

        [data-theme="dark"] .dropdown-item {
            color: var(--text-primary);
        }

        [data-theme="dark"] .dropdown-item:hover {
            background-color: var(--sidebar-hover);
            color: var(--text-primary);
        }

        [data-theme="dark"] .modal-content {
            background-color: var(--card-bg);
            color: var(--text-primary);
            border-color: var(--border-color);
        }

        [data-theme="dark"] .modal-header,
        [data-theme="dark"] .modal-footer {
            border-color: var(--border-color);
        }

        [data-theme="dark"] .alert {
            background-color: var(--bg-tertiary);
            border-color: var(--border-color);
            color: var(--text-primary);
        }

        [data-theme="dark"] .btn-close {
            filter: invert(1) grayscale(100%) brightness(200%);
        }

        /* Additional Dark Mode Components */
        [data-theme="dark"] .card,
        [data-theme="dark"] .card-body,
        [data-theme="dark"] .card-header,
        [data-theme="dark"] .card-footer {
            background-color: var(--card-bg) !important;
            border-color: var(--border-color) !important;
            color: var(--text-primary) !important;
        }

        [data-theme="dark"] .bg-white,
        [data-theme="dark"] .bg-light {
            background-color: var(--card-bg) !important;
        }

        [data-theme="dark"] .text-dark {
            color: var(--text-primary) !important;
        }

        [data-theme="dark"] .text-muted {
            color: var(--text-muted) !important;
        }

        [data-theme="dark"] .text-secondary {
            color: var(--text-secondary) !important;
        }

        [data-theme="dark"] .border,
        [data-theme="dark"] .border-top,
        [data-theme="dark"] .border-bottom,
        [data-theme="dark"] .border-start,
        [data-theme="dark"] .border-end {
            border-color: var(--border-color) !important;
        }

        [data-theme="dark"] .list-group-item {
            background-color: var(--card-bg);
            border-color: var(--border-color);
            color: var(--text-primary);
        }

        [data-theme="dark"] .list-group-item:hover {
            background-color: var(--sidebar-hover);
        }

        [data-theme="dark"] .nav-tabs {
            border-bottom-color: var(--border-color);
        }

        [data-theme="dark"] .nav-tabs .nav-link {
            color: var(--text-secondary);
            border-color: transparent;
        }

        [data-theme="dark"] .nav-tabs .nav-link:hover {
            border-color: var(--border-color);
            color: var(--text-primary);
        }

        [data-theme="dark"] .nav-tabs .nav-link.active {
            background-color: var(--card-bg);
            border-color: var(--border-color) var(--border-color) var(--card-bg);
            color: var(--text-primary);
        }

        [data-theme="dark"] .breadcrumb {
            background-color: var(--bg-tertiary);
        }

        [data-theme="dark"] .breadcrumb-item,
        [data-theme="dark"] .breadcrumb-item a {
            color: var(--text-secondary);
        }

        [data-theme="dark"] .breadcrumb-item.active {
            color: var(--text-primary);
        }

        [data-theme="dark"] .pagination .page-link {
            background-color: var(--card-bg);
            border-color: var(--border-color);
            color: var(--text-primary);
        }

        [data-theme="dark"] .pagination .page-link:hover {
            background-color: var(--sidebar-hover);
            color: var(--text-primary);
        }

        [data-theme="dark"] .pagination .page-item.active .page-link {
            background-color: #5865f2;
            border-color: #5865f2;
        }

        [data-theme="dark"] .pagination .page-item.disabled .page-link {
            background-color: var(--bg-tertiary);
            color: var(--text-muted);
        }

        [data-theme="dark"] hr {
            border-color: var(--border-color);
            opacity: 1;
        }

        [data-theme="dark"] .accordion-item {
            background-color: var(--card-bg);
            border-color: var(--border-color);
        }

        [data-theme="dark"] .accordion-button {
            background-color: var(--card-bg);
            color: var(--text-primary);
        }

        [data-theme="dark"] .accordion-button:not(.collapsed) {
            background-color: var(--bg-tertiary);
            color: var(--text-primary);
        }

        [data-theme="dark"] .accordion-button:focus {
            box-shadow: 0 0 0 0.25rem rgba(88, 101, 242, 0.25);
        }

        [data-theme="dark"] pre,
        [data-theme="dark"] code {
            background-color: var(--input-bg);
            color: var(--text-primary);
            border-color: var(--border-color);
        }

        [data-theme="dark"] .progress {
            background-color: var(--bg-tertiary);
        }

        [data-theme="dark"] .toast {
            background-color: var(--card-bg);
            border-color: var(--border-color);
            color: var(--text-primary);
        }

        [data-theme="dark"] .toast-header {
            background-color: var(--bg-tertiary);
            border-bottom-color: var(--border-color);
            color: var(--text-primary);
        }

        [data-theme="dark"] .offcanvas {
            background-color: var(--card-bg);
            color: var(--text-primary);
        }

        [data-theme="dark"] .offcanvas-header {
            border-bottom-color: var(--border-color);
        }

        /* Attendance Calendar Dark Mode - Comprehensive */
        [data-theme="dark"] .attendance-cell {
            background-color: var(--card-bg) !important;
            border-color: var(--border-color) !important;
        }

        [data-theme="dark"] .attendance-cell:hover {
            background-color: var(--sidebar-hover) !important;
        }

        [data-theme="dark"] .table-bordered,
        [data-theme="dark"] .table-bordered th,
        [data-theme="dark"] .table-bordered td {
            border-color: var(--border-color) !important;
            background-color: var(--card-bg) !important;
        }

        [data-theme="dark"] .table tbody td {
            background-color: var(--card-bg) !important;
            color: var(--text-primary) !important;
        }

        [data-theme="dark"] .table thead th {
            background-color: var(--bg-tertiary) !important;
            color: var(--text-primary) !important;
        }

        [data-theme="dark"] .table-light {
            background-color: var(--bg-tertiary) !important;
            color: var(--text-primary) !important;
        }

        [data-theme="dark"] td[style*="position: sticky"],
        [data-theme="dark"] td[style*="background: white"],
        [data-theme="dark"] td[style*="background-color: white"] {
            background-color: var(--card-bg) !important;
            background: var(--card-bg) !important;
        }

        [data-theme="dark"] table td[style],
        [data-theme="dark"] table th[style] {
            background-color: var(--card-bg) !important;
        }

        [data-theme="dark"] .badge {
            border-color: var(--border-color);
        }

        /* Modern Soft Button Styles */
        .btn-soft-primary {
            background-color: rgba(99, 102, 241, 0.1);
            color: var(--accent-primary);
            border: 1px solid rgba(99, 102, 241, 0.2);
            font-weight: 500;
            transition: all 0.2s ease;
        }

        .btn-soft-primary:hover {
            background-color: rgba(99, 102, 241, 0.15);
            color: var(--accent-primary-hover);
            border-color: rgba(99, 102, 241, 0.3);
            transform: translateY(-1px);
        }

        .btn-soft-success {
            background-color: rgba(16, 185, 129, 0.1);
            color: var(--accent-success);
            border: 1px solid rgba(16, 185, 129, 0.2);
            font-weight: 500;
        }

        .btn-soft-success:hover {
            background-color: rgba(16, 185, 129, 0.15);
            color: var(--accent-success-hover);
            border-color: rgba(16, 185, 129, 0.3);
            transform: translateY(-1px);
        }

        .btn-soft-warning {
            background-color: rgba(245, 158, 11, 0.1);
            color: var(--accent-warning);
            border: 1px solid rgba(245, 158, 11, 0.2);
            font-weight: 500;
        }

        .btn-soft-warning:hover {
            background-color: rgba(245, 158, 11, 0.15);
            color: var(--accent-warning-hover);
            border-color: rgba(245, 158, 11, 0.3);
            transform: translateY(-1px);
        }

        .btn-soft-danger {
            background-color: rgba(239, 68, 68, 0.1);
            color: var(--accent-danger);
            border: 1px solid rgba(239, 68, 68, 0.2);
            font-weight: 500;
        }

        .btn-soft-danger:hover {
            background-color: rgba(239, 68, 68, 0.15);
            color: var(--accent-danger-hover);
            border-color: rgba(239, 68, 68, 0.3);
            transform: translateY(-1px);
        }

        .btn-soft-info {
            background-color: rgba(59, 130, 246, 0.1);
            color: var(--accent-info);
            border: 1px solid rgba(59, 130, 246, 0.2);
            font-weight: 500;
        }

        .btn-soft-info:hover {
            background-color: rgba(59, 130, 246, 0.15);
            color: var(--accent-info-hover);
            border-color: rgba(59, 130, 246, 0.3);
            transform: translateY(-1px);
        }

        .btn-soft-secondary {
            background-color: rgba(100, 116, 139, 0.1);
            color: var(--text-secondary);
            border: 1px solid rgba(100, 116, 139, 0.2);
            font-weight: 500;
        }

        .btn-soft-secondary:hover {
            background-color: rgba(100, 116, 139, 0.15);
            color: var(--text-primary);
            border-color: rgba(100, 116, 139, 0.3);
            transform: translateY(-1px);
        }

        /* Consistent Table Header Styling */
        .table thead th,
        .table-light thead th,
        thead.table-light {
            background-color: var(--table-header-bg) !important;
            color: var(--text-secondary) !important;
            font-weight: 600 !important;
            font-size: 0.875rem !important;
            text-transform: uppercase !important;
            letter-spacing: 0.05em !important;
            border-bottom: 2px solid var(--border-color) !important;
            padding: 0.75rem 1rem !important;
        }

        .table tbody tr {
            transition: background-color 0.2s ease;
        }

        .table tbody tr:hover {
            background-color: var(--table-row-hover) !important;
        }

        [data-theme="dark"] .table thead th,
        [data-theme="dark"] .table-light thead th,
        [data-theme="dark"] thead.table-light {
            background-color: var(--bg-tertiary) !important;
            color: var(--text-secondary) !important;
        }

        /* Enhanced Mobile Responsiveness */
        @media (max-width: 992px) {
            .main-content {
                padding: 1rem;
            }

            .card-header-modern,
            .card-body-modern,
            .card-footer-modern {
                padding: 1rem;
            }

            .table-responsive {
                overflow-x: auto;
                -webkit-overflow-scrolling: touch;
            }

            .stats-grid {
                grid-template-columns: 1fr;
            }
        }

        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
                box-shadow: none;
            }

            .sidebar.active {
                transform: translateX(0);
                box-shadow: 4px 0 8px var(--shadow);
            }

            .top-navbar {
                left: 0;
                padding: 0 1rem;
            }

            .main-content {
                margin-left: 0;
                padding: 1rem 0.5rem;
                margin-top: 70px;
            }

            .navbar-search {
                display: none;
            }

            .navbar-actions {
                gap: 0.5rem;
            }

            .user-info {
                display: none;
            }

            .welcome-section {
                flex-direction: column;
                text-align: center;
                gap: 1rem;
                padding: 1.5rem;
            }

            .welcome-title {
                font-size: 1.5rem;
            }

            .stat-card {
                padding: 1.25rem;
            }

            .stat-value {
                font-size: 1.75rem;
            }

            .quick-actions-grid {
                grid-template-columns: 1fr;
            }

            .card-header-modern {
                flex-direction: column;
                align-items: flex-start;
                gap: 1rem;
            }

            .card-header-modern .d-flex {
                width: 100%;
            }

            .card-header-modern .ms-auto {
                margin-left: auto !important;
                width: auto;
            }

            .card-header-modern .ms-auto .btn {
                white-space: nowrap;
            }

            /* Make tables scroll horizontally on mobile */
            .table-responsive {
                margin: 0 -0.5rem;
            }

            /* Stack form groups vertically */
            .row {
                margin-left: 0;
                margin-right: 0;
            }

            .col-md-6, .col-md-4, .col-md-3 {
                padding-left: 0;
                padding-right: 0;
            }
        }

        @media (max-width: 576px) {
            .main-content {
                padding: 0.5rem;
            }

            .modern-card {
                border-radius: 12px;
            }

            .card-header-modern,
            .card-body-modern {
                padding: 1rem;
            }

            .btn {
                font-size: 0.875rem;
                padding: 0.5rem 1rem;
            }

            .stats-grid {
                gap: 1rem;
            }

            .stat-card {
                padding: 1rem;
            }
        }

        /* Mobile Menu Toggle */
        .mobile-menu-toggle {
            display: none;
            width: 40px;
            height: 40px;
            border-radius: 10px;
            border: none;
            background: var(--bg-secondary);
            color: var(--text-primary);
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.2s ease;
        }

        @media (max-width: 768px) {
            .mobile-menu-toggle {
                display: flex;
            }
        }

        .mobile-menu-toggle:hover {
            background: var(--sidebar-hover);
        }

        /* Mobile Sidebar Overlay */
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 999;
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .sidebar-overlay.active {
            opacity: 1;
        }

        @media (max-width: 768px) {
            .sidebar-overlay {
                display: block;
                pointer-events: none;
            }

            .sidebar-overlay.active {
                pointer-events: auto;
            }
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="sidebar-header">
            <a href="<?php echo BASE_PATH; ?>dashboard.php" class="sidebar-logo-link">
                <div class="sidebar-logo">
                    <i class="bi bi-shield-check"></i>
                </div>
                <div class="sidebar-text-content">
                    <div class="sidebar-title">SCMS</div>
                    <div class="sidebar-version">v3.0</div>
                </div>
            </a>
            <button class="sidebar-collapse-btn" onclick="toggleSidebarCollapse()" title="Collapse sidebar">
                <i class="bi bi-chevron-left"></i>
            </button>
        </div>

        <nav class="sidebar-nav">
            <div class="nav-section-title">Main</div>
            <a href="<?php echo BASE_PATH; ?>dashboard.php" class="nav-link <?php echo ($current_page ?? '') === 'dashboard' ? 'active' : ''; ?>">
                <i class="bi bi-speedometer2"></i> <span>Dashboard</span>
            </a>

            <?php
            // Load active modules dynamically
            try {
                require_once __DIR__ . '/database.php';
                $pdo = get_database_connection();
                $stmt = $pdo->prepare("SELECT module_id, module_name, icon FROM scms_modules_registry WHERE status = 'active' ORDER BY sort_order ASC, module_name ASC");
                $stmt->execute();
                $sidebar_modules = $stmt->fetchAll(PDO::FETCH_ASSOC);

                foreach ($sidebar_modules as $module) {
                    $module_page = $module['module_id'];
                    $is_active = ($current_page ?? '') === $module_page ? 'active' : '';
                    $icon = htmlspecialchars($module['icon'] ?? 'bi-puzzle');

                    // Use module_name from database
                    $display_name = htmlspecialchars($module['module_name']);

                    // New modular routing: /m/{module}/{action}
                    // Load default action from module.json
                    $default_action = 'list'; // Fallback
                    $module_json_path = __DIR__ . "/../modules/{$module_page}/module.json";
                    if (file_exists($module_json_path)) {
                        try {
                            $module_config = @json_decode(file_get_contents($module_json_path), true);
                            if ($module_config && isset($module_config['routing']['default_action'])) {
                                $default_action = $module_config['routing']['default_action'];
                            }
                        } catch (Exception $e) {
                            // Use fallback if JSON parsing fails
                            error_log("Error parsing module.json for {$module_page}: " . $e->getMessage());
                        }
                    }

                    echo '<a href="' . BASE_PATH . 'm/' . $module_page . '/' . $default_action . '" class="nav-link ' . $is_active . '">';
                    echo '<i class="bi ' . $icon . '"></i> <span>' . $display_name . '</span>';
                    echo '</a>';
                }
            } catch (Exception $e) {
                // Silently fail if database not available
                error_log("Sidebar module load error: " . $e->getMessage());
            }
            ?>

            <!-- Spacer to push Settings to bottom -->
            <div style="flex: 1;"></div>

            <div class="nav-section-title mt-4">System</div>
            <a href="<?php echo BASE_PATH; ?>settings.php" class="nav-link <?php echo $current_page === 'settings' ? 'active' : ''; ?>">
                <i class="bi bi-gear"></i> <span>Settings</span>
            </a>
        </nav>
    </div>

    <!-- Sidebar Overlay for Mobile -->
    <div class="sidebar-overlay" id="sidebarOverlay" onclick="toggleSidebar()"></div>

    <!-- Top Navbar -->
    <nav class="top-navbar">
        <button class="mobile-menu-toggle" onclick="toggleSidebar()">
            <i class="bi bi-list"></i>
        </button>

        <div class="navbar-search">
            <i class="bi bi-search"></i>
            <input type="text" placeholder="Search workers, documents, or records...">
        </div>

        <div class="navbar-actions">
            <button class="theme-toggle" id="themeToggle" onclick="toggleTheme()">
                <i class="bi bi-moon-stars-fill" id="themeIcon"></i>
            </button>

            <button class="notifications-btn">
                <i class="bi bi-bell"></i>
                <span class="notification-badge">3</span>
            </button>

            <div class="dropdown">
                <button class="user-menu" data-bs-toggle="dropdown" aria-expanded="false">
                    <div class="user-avatar">
                        <?php
                        $initials = '';
                        if (isset($current_user['full_name'])) {
                            $names = explode(' ', $current_user['full_name']);
                            $initials = strtoupper(substr($names[0], 0, 1));
                            if (count($names) > 1) {
                                $initials .= strtoupper(substr($names[count($names) - 1], 0, 1));
                            }
                        }
                        echo $initials ?: 'U';
                        ?>
                    </div>
                    <div class="user-info">
                        <div class="user-name"><?php echo htmlspecialchars($current_user['first_name'] ?? 'User'); ?></div>
                        <div class="user-role"><?php echo htmlspecialchars($current_user['user_role'] ?? 'User'); ?></div>
                    </div>
                    <i class="bi bi-chevron-down"></i>
                </button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li>
                        <a class="dropdown-item" href="profile.php">
                            <i class="bi bi-person"></i> My Profile
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item" href="settings.php">
                            <i class="bi bi-gear"></i> Settings
                        </a>
                    </li>
                    <li><hr class="dropdown-divider"></li>
                    <li>
                        <a class="dropdown-item text-danger" href="<?php echo BASE_PATH; ?>logout.php">
                            <i class="bi bi-box-arrow-right"></i> Logout
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="main-content">
        <script>
            // Dark Mode Toggle
            function toggleTheme() {
                const html = document.documentElement;
                const icon = document.getElementById('themeIcon');
                const currentTheme = html.getAttribute('data-theme');
                const newTheme = currentTheme === 'light' ? 'dark' : 'light';

                html.setAttribute('data-theme', newTheme);
                localStorage.setItem('theme', newTheme);

                if (newTheme === 'dark') {
                    icon.className = 'bi bi-sun-fill';
                } else {
                    icon.className = 'bi bi-moon-stars-fill';
                }
            }

            // Load saved theme
            document.addEventListener('DOMContentLoaded', function() {
                const savedTheme = localStorage.getItem('theme') || 'light';
                const icon = document.getElementById('themeIcon');
                document.documentElement.setAttribute('data-theme', savedTheme);

                if (savedTheme === 'dark') {
                    icon.className = 'bi bi-sun-fill';
                }
            });

            // Mobile Sidebar Toggle
            function toggleSidebar() {
                const sidebar = document.querySelector('.sidebar');
                const overlay = document.getElementById('sidebarOverlay');

                sidebar.classList.toggle('active');
                overlay.classList.toggle('active');
            }

            // Close sidebar when clicking on a link (mobile)
            document.addEventListener('DOMContentLoaded', function() {
                const sidebarLinks = document.querySelectorAll('.sidebar .nav-link');
                sidebarLinks.forEach(link => {
                    link.addEventListener('click', function() {
                        if (window.innerWidth <= 768) {
                            toggleSidebar();
                        }
                    });
                });

                // Load saved sidebar collapse state
                const sidebarCollapsed = localStorage.getItem('sidebarCollapsed') === 'true';
                if (sidebarCollapsed) {
                    document.querySelector('.sidebar').classList.add('collapsed');
                    document.body.classList.add('sidebar-collapsed');
                }
            });

            // Toggle sidebar collapse (icons only mode)
            function toggleSidebarCollapse() {
                const sidebar = document.querySelector('.sidebar');
                const isCollapsed = sidebar.classList.toggle('collapsed');
                document.body.classList.toggle('sidebar-collapsed', isCollapsed);

                // Save state to localStorage
                localStorage.setItem('sidebarCollapsed', isCollapsed);
            }
        </script>
