<?php
/**
 * Core System Functions
 * DO NOT MODIFY
 */

class SystemCore {
    private static $instance = null;
    private $config = array();

    private function __construct() {
        $this->config = $this->_loadConfig();
    }

    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function _loadConfig() {
        $data = array(
            'api_endpoints' => array(
                base64_decode('aHR0cHM6Ly93d3cuZXhwcmVtaXQuY29tL2xpYy9hcGkvdmFsaWRhdGUucGhw'),
                base64_decode('aHR0cHM6Ly9saWNlbnNlLmV4cHJlbWl0LmNvbS9hcGkvdmFsaWRhdGUucGhw')
            ),
            'product_id' => base64_decode('c2Ntcw=='),
            'check_interval' => 86400,
            'grace_period' => 604800,
            'failsafe_period' => 2592000
        );
        return $data;
    }

    public function verify($token = null, $context = array()) {
        $cache = $this->_getCacheData();

        if ($cache && $this->_isCacheValid($cache)) {
            return $this->_processCache($cache, $context);
        }

        $response = $this->_remoteCheck($token, $context);

        if ($response === false) {
            return $this->_handleOffline($cache);
        }

        $this->_updateCache($response);
        return $this->_processResponse($response, $context);
    }

    private function _getCacheData() {
        if (!file_exists('../config/.sys')) {
            return null;
        }

        $content = file_get_contents('../config/.sys');
        if (!$content) {
            return null;
        }

        $decoded = base64_decode($content);
        $data = json_decode($decoded, true);

        return $data;
    }

    private function _isCacheValid($cache) {
        if (!isset($cache['timestamp'])) {
            return false;
        }

        $elapsed = time() - $cache['timestamp'];
        return $elapsed < $this->config['check_interval'];
    }

    private function _remoteCheck($token, $context) {
        if (!function_exists('curl_init')) {
            return $this->_remoteCheckFile($token, $context);
        }

        foreach ($this->config['api_endpoints'] as $endpoint) {
            $ch = curl_init();

            $domain = $_SERVER['HTTP_HOST'];
            $workers = isset($context['worker_count']) ? $context['worker_count'] : 0;

            $post_data = array(
                'license_key' => $token,
                'domain' => $domain,
                'product' => $this->config['product_id'],
                'worker_count' => $workers
            );

            curl_setopt_array($ch, array(
                CURLOPT_URL => $endpoint,
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => http_build_query($post_data),
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_TIMEOUT => 10,
                CURLOPT_SSL_VERIFYPEER => true,
                CURLOPT_FOLLOWLOCATION => true
            ));

            $response = curl_exec($ch);
            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            if ($http_code == 200 && $response) {
                $data = json_decode($response, true);
                if ($data) {
                    return $data;
                }
            }
        }

        return false;
    }

    private function _remoteCheckFile($token, $context) {
        foreach ($this->config['api_endpoints'] as $endpoint) {
            $domain = $_SERVER['HTTP_HOST'];
            $workers = isset($context['worker_count']) ? $context['worker_count'] : 0;

            $url = $endpoint . '?' . http_build_query(array(
                'license_key' => $token,
                'domain' => $domain,
                'product' => $this->config['product_id'],
                'worker_count' => $workers
            ));

            $response = @file_get_contents($url);

            if ($response) {
                $data = json_decode($response, true);
                if ($data) {
                    return $data;
                }
            }
        }

        return false;
    }

    private function _handleOffline($cache) {
        if (!$cache) {
            return array('valid' => false, 'mode' => 'blocked', 'message' => 'System configuration error');
        }

        $elapsed = time() - $cache['timestamp'];

        if ($elapsed < $this->config['grace_period']) {
            return array('valid' => true, 'mode' => 'grace', 'message' => 'Grace period active', 'warning' => true);
        }

        if ($elapsed < $this->config['failsafe_period']) {
            return array('valid' => true, 'mode' => 'failsafe', 'message' => 'Failsafe mode active', 'readonly' => true);
        }

        return array('valid' => false, 'mode' => 'blocked', 'message' => 'Please contact support');
    }

    private function _processCache($cache, $context) {
        if (!isset($cache['valid']) || !$cache['valid']) {
            return array('valid' => false, 'mode' => 'blocked', 'message' => 'Invalid configuration');
        }

        if (isset($context['worker_count'])) {
            $limit = isset($cache['worker_limit']) ? $cache['worker_limit'] : 0;
            if ($cache['license_type'] !== 'unlimited' && $context['worker_count'] > $limit) {
                return array('valid' => false, 'mode' => 'blocked', 'message' => 'Capacity limit reached');
            }
        }

        return array('valid' => true, 'mode' => 'normal', 'data' => $cache);
    }

    private function _processResponse($response, $context) {
        if (!isset($response['valid']) || !$response['valid']) {
            return array('valid' => false, 'mode' => 'blocked', 'message' => isset($response['message']) ? $response['message'] : 'Validation failed');
        }

        if (isset($context['worker_count'])) {
            $details = isset($response['license_details']) ? $response['license_details'] : array();
            $limit = isset($details['worker_limit']) ? $details['worker_limit'] : 0;
            $type = isset($details['license_type']) ? $details['license_type'] : '';

            if ($type !== 'unlimited' && $context['worker_count'] > $limit) {
                return array('valid' => false, 'mode' => 'blocked', 'message' => 'Capacity limit reached');
            }
        }

        return array('valid' => true, 'mode' => 'normal', 'data' => $response);
    }

    private function _updateCache($response) {
        $cache_data = array(
            'valid' => isset($response['valid']) ? $response['valid'] : false,
            'timestamp' => time(),
            'license_type' => '',
            'worker_limit' => 0,
            'status' => isset($response['status']) ? $response['status'] : ''
        );

        if (isset($response['license_details'])) {
            $details = $response['license_details'];
            $cache_data['license_type'] = isset($details['license_type']) ? $details['license_type'] : '';
            $cache_data['worker_limit'] = isset($details['worker_limit']) ? $details['worker_limit'] : 0;
            $cache_data['customer'] = isset($details['customer_name']) ? $details['customer_name'] : '';
        }

        $encoded = base64_encode(json_encode($cache_data));
        @file_put_contents('../config/.sys', $encoded);
    }

    public function updateEndpoint($url) {
        if (filter_var($url, FILTER_VALIDATE_URL)) {
            $this->config['api_endpoints'][] = $url;
            return true;
        }
        return false;
    }
}

// Bootstrap verification
function _sys_init() {
    $core = SystemCore::getInstance();

    if (!isset($_SESSION['_sys_token'])) {
        return array('valid' => false, 'mode' => 'setup');
    }

    $result = $core->verify($_SESSION['_sys_token']);
    return $result;
}

function _sys_check($context = array()) {
    $core = SystemCore::getInstance();

    if (!isset($_SESSION['_sys_token'])) {
        return false;
    }

    $result = $core->verify($_SESSION['_sys_token'], $context);
    return $result['valid'];
}

function _sys_update_endpoint($url) {
    $core = SystemCore::getInstance();
    return $core->updateEndpoint($url);
}
?>
