<?php
/**
 * Holidays Management - Main Page
 * Redirects to holidays module
 */

session_start();
require_once 'config/database.php';
require_once 'includes/database.php';
require_once 'includes/session_manager.php';

// Require authentication
require_authentication();

// Get current user
$current_user = get_logged_in_user();
if (!$current_user) {
    header('Location: login.php');
    exit;
}

$page_title = 'Holidays';
$current_page = 'holidays';

// Include header with sidebar
include 'includes/header.php';

// Set embedded flag
define('MODULE_EMBEDDED', true);
?>

<div class="dashboard-container">
    <?php
    // Include the holidays module
    if (file_exists('modules/holidays/index.php')) {
        include 'modules/holidays/index.php';
    } elseif (file_exists('modules/holidays/list.php')) {
        include 'modules/holidays/list.php';
    } else {
        echo "<div class='alert alert-danger'>Holidays module not found</div>";
    }
    ?>
</div>

<?php include 'includes/footer.php'; ?>
