<?php
/**
 * Fix Users Table - Add Missing Columns
 */
require_once 'config/database.php';

echo "=== FIXING USERS TABLE ===\n\n";

// Check current structure
echo "1. Checking current table structure...\n";
$stmt = $pdo->query("DESCRIBE " . DB_PREFIX . "users");
$columns = [];
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $columns[] = $row['Field'];
}

echo "   Current columns: " . implode(', ', $columns) . "\n\n";

// Check if last_login exists
if (!in_array('last_login', $columns)) {
    echo "2. Adding last_login column...\n";
    $pdo->exec("ALTER TABLE " . DB_PREFIX . "users ADD COLUMN last_login DATETIME NULL AFTER password_hash");
    echo "   ✓ last_login column added\n\n";
} else {
    echo "2. last_login column already exists ✓\n\n";
}

// Check if created_at exists
if (!in_array('created_at', $columns)) {
    echo "3. Adding created_at column...\n";
    $pdo->exec("ALTER TABLE " . DB_PREFIX . "users ADD COLUMN created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP");
    echo "   ✓ created_at column added\n\n";
} else {
    echo "3. created_at column already exists ✓\n\n";
}

// Check if updated_at exists
if (!in_array('updated_at', $columns)) {
    echo "4. Adding updated_at column...\n";
    $pdo->exec("ALTER TABLE " . DB_PREFIX . "users ADD COLUMN updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP");
    echo "   ✓ updated_at column added\n\n";
} else {
    echo "4. updated_at column already exists ✓\n\n";
}

// Show final structure
echo "5. Final table structure:\n";
$stmt = $pdo->query("DESCRIBE " . DB_PREFIX . "users");
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    echo "   - {$row['Field']} ({$row['Type']}) " . ($row['Null'] == 'YES' ? 'NULL' : 'NOT NULL') . "\n";
}

echo "\n=== TABLE FIXED ===\n";
