<?php
require_once 'config/database.php';
require_once 'includes/database.php';

header('Content-Type: text/plain');

try {
    $pdo = get_database_connection();

    echo "Step 1: Dropping old table...\n";
    $pdo->exec("DROP TABLE IF EXISTS scms_modules_registry");
    echo "OK\n\n";

    echo "Step 2: Creating new table...\n";
    $sql = "CREATE TABLE scms_modules_registry (
      id int(11) NOT NULL AUTO_INCREMENT,
      module_id varchar(50) NOT NULL,
      name varchar(100) NOT NULL,
      description text,
      version varchar(20) NOT NULL,
      author varchar(100) DEFAULT NULL,
      icon varchar(50) DEFAULT 'bi-puzzle',
      status enum('active','inactive') NOT NULL DEFAULT 'inactive',
      settings text,
      sort_order int(11) DEFAULT 0,
      installed_at datetime DEFAULT NULL,
      activated_at datetime DEFAULT NULL,
      updated_at datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
      PRIMARY KEY (id),
      UNIQUE KEY module_id (module_id),
      KEY status (status),
      KEY sort_order (sort_order)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

    $pdo->exec($sql);
    echo "OK\n\n";

    echo "SUCCESS! Table recreated with correct schema.\n";
    echo "\nNow go to Settings > Modules and click Install on any module.\n";

} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}
?>
