<?php
/**
 * URGENT FIX: Recreate modules_registry table with correct structure
 */
require_once 'config/database.php';

echo "=== FIXING MODULES REGISTRY TABLE ===\n\n";

// Drop old table
echo "1. Dropping old modules_registry table...\n";
$pdo->exec("DROP TABLE IF EXISTS " . DB_PREFIX . "modules_registry");
echo "   ✓ Old table dropped\n\n";

// Create new table with correct structure
echo "2. Creating new modules_registry table with correct structure...\n";
$sql = "CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "modules_registry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` varchar(50) NOT NULL,
  `name` varchar(100) NOT NULL,
  `description` text,
  `version` varchar(20) NOT NULL,
  `author` varchar(100) DEFAULT NULL,
  `icon` varchar(50) DEFAULT 'bi-puzzle',
  `status` enum('active','inactive') NOT NULL DEFAULT 'inactive',
  `settings` text COMMENT 'JSON encoded settings',
  `sort_order` int(11) DEFAULT 0,
  `installed_at` datetime DEFAULT NULL,
  `activated_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `module_id` (`module_id`),
  KEY `status` (`status`),
  KEY `sort_order` (`sort_order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

$pdo->exec($sql);
echo "   ✓ New table created\n\n";

// Scan and register all modules
echo "3. Scanning and registering modules...\n";
require_once 'includes/ModuleManager.php';
$moduleManager = new ModuleManager($pdo);
$count = $moduleManager->scanAndRegister();
echo "   ✓ Registered $count modules\n\n";

// Show registered modules
echo "4. Modules registered:\n";
$stmt = $pdo->query("SELECT module_id, name, status, sort_order FROM " . DB_PREFIX . "modules_registry ORDER BY sort_order");
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    echo sprintf("   - %-12s | %-25s | %-8s | Order: %d\n",
        $row['module_id'],
        $row['name'],
        $row['status'],
        $row['sort_order']
    );
}

echo "\n=== FIX COMPLETE ===\n";
echo "Please refresh your browser to see all modules!\n";
