<?php
/**
 * Documents Management - Main Page
 */

session_start();
require_once 'config/database.php';
require_once 'includes/database.php';
require_once 'includes/session_manager.php';

// Require authentication
require_authentication();

// Get current user
$current_user = get_logged_in_user();
if (!$current_user) {
    header('Location: login.php');
    exit;
}

$page_title = 'Documents';
$current_page = 'documents';

// Include header with sidebar
include 'includes/header.php';

// Set embedded flag
define('MODULE_EMBEDDED', true);

?>

<div class="dashboard-container">
    <?php
    if (file_exists('modules/documents/list.php')) {
        include 'modules/documents/list.php';
    } else {
        echo "<div class='alert alert-danger'>Documents module not found</div>";
    }
    ?>
</div>

<?php include 'includes/footer.php'; ?>
