<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<!DOCTYPE html><html><head><title>Diagnostic</title>";
echo "<style>body{font-family:monospace;padding:20px;background:#1a1a1a;color:#0f0;}</style>";
echo "</head><body><h1>SCMS Diagnostic</h1>";

echo "<h2>Step 1: Include Files</h2>";
try {
    require_once 'config/database.php';
    echo "✓ config/database.php loaded<br>";
    
    require_once 'includes/database.php';
    echo "✓ includes/database.php loaded<br>";
    
    require_once 'includes/ModuleManager.php';
    echo "✓ includes/ModuleManager.php loaded<br>";
} catch (Exception $e) {
    echo "✗ Error loading files: " . $e->getMessage() . "<br>";
    exit;
}

echo "<h2>Step 2: Database Connection</h2>";
try {
    $pdo = get_database_connection();
    echo "✓ Database connected<br>";
} catch (Exception $e) {
    echo "✗ Database error: " . $e->getMessage() . "<br>";
    exit;
}

echo "<h2>Step 3: Check Table</h2>";
try {
    $stmt = $pdo->query("SHOW TABLES LIKE 'scms_modules_registry'");
    if ($stmt->fetch()) {
        echo "✓ Table exists<br>";
        
        $stmt = $pdo->query("SELECT COUNT(*) as cnt FROM scms_modules_registry");
        $row = $stmt->fetch();
        echo "✓ Current modules count: " . $row['cnt'] . "<br>";
    } else {
        echo "✗ Table does not exist<br>";
        exit;
    }
} catch (Exception $e) {
    echo "✗ Table error: " . $e->getMessage() . "<br>";
    exit;
}

echo "<h2>Step 4: Check ModuleManager</h2>";
try {
    $moduleManager = new ModuleManager($pdo);
    echo "✓ ModuleManager created<br>";
} catch (Exception $e) {
    echo "✗ ModuleManager error: " . $e->getMessage() . "<br>";
    exit;
}

echo "<h2>Step 5: Test scanAndRegister</h2>";
try {
    $count = $moduleManager->scanAndRegister();
    echo "✓ scanAndRegister returned: $count<br>";
    
    $stmt = $pdo->query("SELECT COUNT(*) as cnt FROM scms_modules_registry");
    $row = $stmt->fetch();
    echo "✓ Modules in DB now: " . $row['cnt'] . "<br>";
    
    if ($row['cnt'] == 0) {
        echo "<br>⚠️ WARNING: scanAndRegister found $count modules but database still has 0!<br>";
        echo "This means the INSERT is failing silently.<br>";
    }
    
} catch (Exception $e) {
    echo "✗ Scan error: " . $e->getMessage() . "<br>";
    echo "Trace: <pre>" . $e->getTraceAsString() . "</pre>";
}

echo "<h2>Step 6: List Modules</h2>";
try {
    $stmt = $pdo->query("SELECT module_id, name, status FROM scms_modules_registry");
    $modules = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (empty($modules)) {
        echo "No modules found<br>";
    } else {
        echo "<ul>";
        foreach ($modules as $m) {
            echo "<li>{$m['module_id']}: {$m['name']} ({$m['status']})</li>";
        }
        echo "</ul>";
    }
} catch (Exception $e) {
    echo "✗ List error: " . $e->getMessage() . "<br>";
}

echo "</body></html>";
?>
