<?php
/**
 * Describe users table structure
 */

require_once 'config/database.php';
require_once 'includes/database.php';

try {
    $stmt = $pdo->query("DESCRIBE " . DB_PREFIX . "users");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "Columns in " . DB_PREFIX . "users table:\n";
    foreach ($columns as $col) {
        echo "  - {$col['Field']} ({$col['Type']}) - Null: {$col['Null']} - Default: " . ($col['Default'] ?? 'NULL') . "\n";
    }
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}
