-- Create modules_registry table for Module Manager
-- This table tracks all registered modules in the system

CREATE TABLE IF NOT EXISTS `scms_modules_registry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` varchar(50) NOT NULL,
  `name` varchar(100) NOT NULL,
  `description` text,
  `version` varchar(20) NOT NULL,
  `author` varchar(100) DEFAULT NULL,
  `icon` varchar(50) DEFAULT 'bi-puzzle',
  `status` enum('active','inactive') NOT NULL DEFAULT 'inactive',
  `settings` text COMMENT 'JSON encoded settings',
  `sort_order` int(11) DEFAULT 0,
  `installed_at` datetime DEFAULT NULL,
  `activated_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `module_id` (`module_id`),
  KEY `status` (`status`),
  KEY `sort_order` (`sort_order`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
