<?php
require_once 'includes/database.php';

header('Content-Type: text/plain');
echo "=== Creating Address History and Qualifications Tables ===\n\n";

try {
    $pdo = get_db_connection();

    // Create address history table
    $sql_address = "CREATE TABLE IF NOT EXISTS scms_worker_address_history (
        id INT AUTO_INCREMENT PRIMARY KEY,
        worker_id INT NOT NULL,
        address_type ENUM('current', 'previous') DEFAULT 'previous',
        address_line1 VARCHAR(255),
        address_line2 VARCHAR(255),
        city VARCHAR(100),
        county VARCHAR(100),
        postcode VARCHAR(20),
        country VARCHAR(100) DEFAULT 'United Kingdom',
        move_in_date DATE,
        move_out_date DATE,
        is_current TINYINT(1) DEFAULT 0,
        verification_status ENUM('verified', 'pending', 'unverified') DEFAULT 'unverified',
        notes TEXT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        FOREIGN KEY (worker_id) REFERENCES scms_sponsored_workers(id) ON DELETE CASCADE,
        INDEX idx_worker_id (worker_id),
        INDEX idx_move_in_date (move_in_date),
        INDEX idx_is_current (is_current)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

    $pdo->exec($sql_address);
    echo "✓ Created table: scms_worker_address_history\n\n";

    // Create qualifications table
    $sql_qualifications = "CREATE TABLE IF NOT EXISTS scms_worker_qualifications (
        id INT AUTO_INCREMENT PRIMARY KEY,
        worker_id INT NOT NULL,
        qualification_type ENUM('academic', 'professional', 'training', 'certification', 'license', 'other') DEFAULT 'professional',
        qualification_name VARCHAR(255) NOT NULL,
        issuing_organization VARCHAR(255),
        qualification_level VARCHAR(100),
        field_of_study VARCHAR(255),
        certificate_number VARCHAR(100),
        issue_date DATE,
        expiry_date DATE,
        is_verified TINYINT(1) DEFAULT 0,
        verification_date DATE,
        grade_result VARCHAR(100),
        country VARCHAR(100),
        document_path VARCHAR(255),
        notes TEXT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        FOREIGN KEY (worker_id) REFERENCES scms_sponsored_workers(id) ON DELETE CASCADE,
        INDEX idx_worker_id (worker_id),
        INDEX idx_qualification_type (qualification_type),
        INDEX idx_expiry_date (expiry_date)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

    $pdo->exec($sql_qualifications);
    echo "✓ Created table: scms_worker_qualifications\n\n";

    // Create employment history table (for completeness)
    $sql_employment = "CREATE TABLE IF NOT EXISTS scms_worker_employment_history (
        id INT AUTO_INCREMENT PRIMARY KEY,
        worker_id INT NOT NULL,
        employer_name VARCHAR(255) NOT NULL,
        job_title VARCHAR(255),
        employment_type VARCHAR(100),
        start_date DATE,
        end_date DATE,
        is_current TINYINT(1) DEFAULT 0,
        responsibilities TEXT,
        reason_for_leaving VARCHAR(255),
        reference_name VARCHAR(255),
        reference_phone VARCHAR(50),
        reference_email VARCHAR(255),
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        FOREIGN KEY (worker_id) REFERENCES scms_sponsored_workers(id) ON DELETE CASCADE,
        INDEX idx_worker_id (worker_id),
        INDEX idx_start_date (start_date)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

    $pdo->exec($sql_employment);
    echo "✓ Created table: scms_worker_employment_history\n\n";

    echo "=== Summary ===\n";
    echo "✓ Address History Table - Ready for 3-5 year history tracking\n";
    echo "✓ Qualifications Table - Ready for academic, professional, training records\n";
    echo "✓ Employment History Table - Ready for job history tracking\n";
    echo "\n✓ All tables created successfully!\n";

} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo "Trace: " . $e->getTraceAsString();
}
