<?php
/**
 * SCMS Global Routes Configuration
 * Define base URL and common paths to prevent relative path issues
 */

// Auto-detect the base URL
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https://' : 'http://';
$host = $_SERVER['HTTP_HOST'];

// Base URL for the SCMS application (change this if installed in different location)
define('BASE_URL', $protocol . $host . '/sys/scms/');
define('BASE_PATH', '/sys/scms/');

// Common page routes
define('ROUTE_DASHBOARD', BASE_PATH . 'dashboard.php');
define('ROUTE_WORKERS', BASE_PATH . 'workers.php');
define('ROUTE_ATTENDANCE', BASE_PATH . 'attendance.php');
define('ROUTE_HOLIDAYS', BASE_PATH . 'holidays.php');
define('ROUTE_DOCUMENTS', BASE_PATH . 'documents.php');
define('ROUTE_LOCATIONS', BASE_PATH . 'locations.php');
define('ROUTE_COS', BASE_PATH . 'cos.php');
define('ROUTE_REPORTS', BASE_PATH . 'reports.php');
define('ROUTE_HO_REPORTS', BASE_PATH . 'ho_reports.php');
define('ROUTE_PROFILE', BASE_PATH . 'profile.php');
define('ROUTE_USERS', BASE_PATH . 'users.php');
define('ROUTE_SETTINGS', BASE_PATH . 'settings.php');
define('ROUTE_AUDIT', BASE_PATH . 'audit.php');
define('ROUTE_LOGIN', BASE_PATH . 'login.php');
define('ROUTE_LOGOUT', BASE_PATH . 'logout.php');

// Module paths
define('MODULE_WORKERS_PATH', BASE_PATH . 'modules/workers/');
define('MODULE_ATTENDANCE_PATH', BASE_PATH . 'modules/attendance/');
define('MODULE_HOLIDAYS_PATH', BASE_PATH . 'modules/holidays/');
define('MODULE_DOCUMENTS_PATH', BASE_PATH . 'modules/documents/');

// Helper function to generate URL
function route($path) {
    return BASE_PATH . $path;
}

// Helper function to redirect
function redirect_to($path) {
    if (strpos($path, 'http') === 0) {
        header("Location: $path");
    } else {
        header("Location: " . BASE_PATH . $path);
    }
    exit;
}
