<?php
require_once 'config/database.php';

try {
    echo "=== sponsored_workers table structure ===\n";
    $stmt = $pdo->query("DESCRIBE scms_sponsored_workers");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $existing_columns = [];
    foreach ($columns as $col) {
        $existing_columns[] = $col['Field'];
        echo $col['Field'] . " - " . $col['Type'];
        if ($col['Null'] === 'YES') echo " (nullable)";
        if ($col['Default'] !== null) echo " [default: " . $col['Default'] . "]";
        echo "\n";
    }

    echo "\n=== Checking for missing common columns ===\n";
    $expected_columns = ['gender', 'place_of_birth', 'passport_country', 'driving_license'];

    foreach ($expected_columns as $col) {
        if (!in_array($col, $existing_columns)) {
            echo "❌ MISSING: $col\n";
        } else {
            echo "✓ EXISTS: $col\n";
        }
    }

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
