<?php
require_once 'config/database.php';
require_once 'includes/database.php';

echo "==========================================================\n";
echo "SCMS Modules Registry Check\n";
echo "==========================================================\n\n";

try {
    // First check table structure
    echo "Table structure:\n";
    $stmt = $pdo->query("DESCRIBE scms_modules_registry");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    foreach ($columns as $col) {
        echo "  - {$col['Field']} ({$col['Type']})\n";
    }
    echo "\n";

    // Get all modules
    $stmt = $pdo->query("SELECT * FROM scms_modules_registry");
    $modules = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "Total modules in registry: " . count($modules) . "\n\n";

    if (empty($modules)) {
        echo "⚠ NO MODULES REGISTERED!\n";
        echo "The modules_registry table is empty.\n\n";
    } else {
        foreach ($modules as $module) {
            echo "Module: {$module['module_id']}\n";
            echo "  Name: " . ($module['module_name'] ?? 'N/A') . "\n";
            echo "  Status: {$module['status']}\n";
            echo "  Version: " . ($module['version'] ?? 'N/A') . "\n";
            if (isset($module['icon'])) echo "  Icon: {$module['icon']}\n";
            if (isset($module['menu_title'])) echo "  Menu Title: {$module['menu_title']}\n";
            if (isset($module['display_order'])) echo "  Display Order: {$module['display_order']}\n";
            echo "\n";
        }

        $active_count = count(array_filter($modules, fn($m) => $m['status'] === 'active'));
        echo "Active modules: $active_count\n";
        echo "Inactive modules: " . (count($modules) - $active_count) . "\n";
    }

} catch (PDOException $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}

echo "\n==========================================================\n";
?>
