<?php
/**
 * Check ML (Maternity Leave) references in database
 */
require_once 'config/database.php';
require_once 'includes/database.php';

$pdo = get_database_connection();

echo "=== Checking ML References in Database ===\n\n";

// Check absence_types table
echo "1. Absence Types Table:\n";
try {
    $stmt = $pdo->query("SELECT * FROM " . DB_PREFIX . "absence_types WHERE code = 'ML'");
    $ml_type = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($ml_type) {
        echo "   Found ML entry:\n";
        foreach ($ml_type as $key => $value) {
            echo "   - $key: $value\n";
        }
    } else {
        echo "   No ML entry found\n";
    }
} catch (Exception $e) {
    echo "   Table doesn't exist or error: " . $e->getMessage() . "\n";
}

echo "\n2. Checking attendance_records for ML:\n";
try {
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM " . DB_PREFIX . "attendance_records WHERE status = 'ML'");
    $count = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "   Found " . $count['count'] . " attendance records with ML status\n";
} catch (Exception $e) {
    echo "   Error: " . $e->getMessage() . "\n";
}

echo "\n3. Checking absence_authorizations for ML:\n";
try {
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM " . DB_PREFIX . "absence_authorizations WHERE absence_type = 'ML'");
    $count = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "   Found " . $count['count'] . " absence authorizations with ML type\n";
} catch (Exception $e) {
    echo "   Error: " . $e->getMessage() . "\n";
}

echo "\n4. Checking roster_overrides for ML:\n";
try {
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM " . DB_PREFIX . "roster_overrides WHERE absence_type = 'ML'");
    $count = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "   Found " . $count['count'] . " roster overrides with ML type\n";
} catch (Exception $e) {
    echo "   Error: " . $e->getMessage() . "\n";
}

echo "\n=== Check Complete ===\n";
