<?php
require_once 'config/database.php';

try {
    echo "=== work_locations table structure ===\n";
    $stmt = $pdo->query("DESCRIBE scms_work_locations");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($columns as $col) {
        echo $col['Field'] . " - " . $col['Type'];
        if ($col['Null'] === 'YES') echo " (nullable)";
        if ($col['Default'] !== null) echo " [default: " . $col['Default'] . "]";
        echo "\n";
    }

    echo "\n=== Sample location ===\n";
    $stmt = $pdo->query("SELECT * FROM scms_work_locations LIMIT 1");
    $loc = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($loc) {
        print_r($loc);
    }

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
