<?php
/**
 * Check recent error logs
 */

require_once 'config/database.php';
require_once 'includes/database.php';

try {
    $pdo = get_database_connection();

    echo "=== RECENT ERROR LOGS (Last 10) ===\n\n";

    $stmt = $pdo->query("SELECT * FROM scms_error_logs
                        ORDER BY created_at DESC
                        LIMIT 10");

    $errors = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($errors)) {
        echo "No errors found in database.\n\n";
        echo "Checking if error_logs table exists...\n";
        $tables = $pdo->query("SHOW TABLES LIKE 'scms_error_logs'")->fetchAll();
        if (empty($tables)) {
            echo "❌ Table scms_error_logs does NOT exist!\n";
        } else {
            echo "✅ Table exists but is empty.\n";
        }
    } else {
        foreach ($errors as $error) {
            echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
            echo "Time: " . $error['created_at'] . "\n";
            echo "Severity: " . $error['severity'] . "\n";
            echo "File: " . ($error['file'] ?? 'N/A') . ":" . ($error['line'] ?? 'N/A') . "\n";
            echo "Message: " . $error['error_message'] . "\n";
            echo "User: " . ($error['user_id'] ?? 'Not logged in') . "\n";
            echo "URL: " . ($error['request_url'] ?? 'N/A') . "\n";
            echo "\n";
        }
    }

    // Also check PHP error log file
    echo "\n=== PHP ERROR LOG FILE ===\n\n";

    $error_log_paths = [
        'includes/logs/error.log',
        'logs/error.log',
        'error_log',
        '../error_log',
    ];

    foreach ($error_log_paths as $path) {
        if (file_exists($path)) {
            echo "Found error log: $path\n";
            echo "Last 20 lines:\n";
            echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━\n";
            $lines = file($path);
            $last_lines = array_slice($lines, -20);
            echo implode('', $last_lines);
            echo "\n";
        }
    }

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
