<?php
require_once 'config/database.php';

try {
    echo "=== Checking modules_registry table structure ===\n";
    $stmt = $pdo->query("DESCRIBE scms_modules_registry");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "Columns:\n";
    foreach ($columns as $col) {
        echo "  - " . $col['Field'] . " (" . $col['Type'] . ")\n";
    }

    echo "\n=== Current modules ===\n";
    $stmt = $pdo->query("SELECT * FROM scms_modules_registry LIMIT 3");
    $modules = $stmt->fetchAll(PDO::FETCH_ASSOC);
    if ($modules) {
        print_r($modules[0]); // Show first module structure
    }

    echo "\n=== Registering locations module ===\n";

    // Simple insert based on what columns likely exist
    $sql = "INSERT INTO scms_modules_registry (module_id, status)
            VALUES ('locations', 'active')
            ON DUPLICATE KEY UPDATE status = 'active'";

    $pdo->exec($sql);
    echo "✓ Locations module registered!\n";

    // Verify
    $stmt = $pdo->query("SELECT * FROM scms_modules_registry WHERE module_id = 'locations'");
    $module = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($module) {
        echo "\nVerified:\n";
        print_r($module);
    }

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "SQL State: " . $e->getCode() . "\n";
}
?>
