<?php
require_once 'config/database.php';

$fields_to_check = [
    'passport_issue_date', 'passport_expiry', 'visa_number', 'visa_issue_date',
    'brp_number', 'brp_expiry', 'share_code', 'share_code_expiry',
    'probation_end_date', 'personal_email', 'mobile_phone',
    'emergency_contact_relationship', 'emergency_contact_address',
    'secondary_emergency_contact', 'secondary_emergency_phone', 'secondary_emergency_relationship',
    'bank_name', 'bank_account_number', 'bank_sort_code', 'notes'
];

try {
    echo "=== Checking for missing fields ===\n";

    $stmt = $pdo->query("DESCRIBE scms_sponsored_workers");
    $existing = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $existing[] = $row['Field'];
    }

    $missing = [];
    foreach ($fields_to_check as $field) {
        if (!in_array($field, $existing)) {
            echo "❌ MISSING: $field\n";
            $missing[] = $field;
        }
    }

    if (empty($missing)) {
        echo "✓ All fields exist!\n";
    } else {
        echo "\nTotal missing: " . count($missing) . "\n";
    }

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
