<?php
/**
 * Audit all database tables and their data
 */

require_once 'config/database.php';
require_once 'includes/database.php';

try {
    $pdo = get_database_connection();

    echo "=== DATABASE TABLES AUDIT ===\n\n";

    // Get all tables
    $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);

    foreach($tables as $table) {
        if(strpos($table, 'scms_') === 0) {
            $count = $pdo->query("SELECT COUNT(*) FROM `$table`")->fetchColumn();
            echo sprintf("%-40s => %d records\n", $table, $count);
        }
    }

    echo "\n=== MODULES REGISTRY ===\n\n";
    $modules = $pdo->query("SELECT * FROM scms_modules_registry ORDER BY sort_order ASC")->fetchAll(PDO::FETCH_ASSOC);
    foreach($modules as $mod) {
        echo sprintf("%-15s | %-25s | Status: %-10s | Sort: %d\n",
            $mod['module_id'],
            $mod['module_name'],
            $mod['status'],
            $mod['sort_order']
        );
    }

    echo "\n=== WORKERS DATA ===\n\n";
    $workers = $pdo->query("SELECT COUNT(*) as total,
                                  SUM(CASE WHEN status = 'active' THEN 1 ELSE 0 END) as active,
                                  SUM(CASE WHEN status = 'inactive' THEN 1 ELSE 0 END) as inactive
                           FROM scms_sponsored_workers")->fetch(PDO::FETCH_ASSOC);
    echo "Total Workers: {$workers['total']} (Active: {$workers['active']}, Inactive: {$workers['inactive']})\n";

    echo "\n=== COS RECORDS ===\n\n";
    $cos = $pdo->query("SELECT COUNT(*) as total,
                              SUM(CASE WHEN status = 'assigned' THEN 1 ELSE 0 END) as assigned,
                              SUM(CASE WHEN status = 'used' THEN 1 ELSE 0 END) as used,
                              SUM(CASE WHEN status = 'withdrawn' THEN 1 ELSE 0 END) as withdrawn
                       FROM scms_cos_records")->fetch(PDO::FETCH_ASSOC);
    echo "Total CoS: {$cos['total']} (Assigned: {$cos['assigned']}, Used: {$cos['used']}, Withdrawn: {$cos['withdrawn']})\n";

    echo "\n=== DOCUMENTS ===\n\n";
    $docs = $pdo->query("SELECT COUNT(*) as total FROM scms_documents")->fetch(PDO::FETCH_ASSOC);
    echo "Total Documents: {$docs['total']}\n";

    echo "\n=== HOLIDAYS ===\n\n";
    $holidays = $pdo->query("SELECT COUNT(*) as total FROM scms_holidays")->fetch(PDO::FETCH_ASSOC);
    echo "Total Holidays: {$holidays['total']}\n";

    echo "\n=== LOCATIONS ===\n\n";
    $locations = $pdo->query("SELECT COUNT(*) as total FROM scms_work_locations")->fetch(PDO::FETCH_ASSOC);
    echo "Total Locations: {$locations['total']}\n";

    echo "\n=== RTW CHECKS ===\n\n";
    $rtw = $pdo->query("SELECT COUNT(*) as total FROM scms_rtw_checks")->fetch(PDO::FETCH_ASSOC);
    echo "Total RTW Checks: {$rtw['total']}\n";

    echo "\n=== ATTENDANCE ===\n\n";
    $attendance = $pdo->query("SELECT COUNT(*) as total FROM scms_attendance_records")->fetch(PDO::FETCH_ASSOC);
    echo "Total Attendance Records: {$attendance['total']}\n";

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
