<?php
/**
 * Audit Logs
 */

session_start();
require_once 'config/database.php';
require_once 'includes/database.php';
require_once 'includes/session_manager.php';

require_authentication();

$page_title = 'Audit Logs';
$current_page = 'audit';

// Check admin permission
$current_user = get_logged_in_user();
if ($current_user['permission_level'] < 100) {
    die('Access denied. Admin permission required.');
}

include 'includes/header.php';
?>

<div class="dashboard-container">
    <div class="welcome-section">
        <div class="welcome-content">
            <h1 class="welcome-title">
                <i class="bi bi-journal-text"></i> Audit Logs
            </h1>
            <p class="welcome-subtitle">System activity and security logs</p>
        </div>
    </div>

    <div class="modern-card">
        <div class="card-body-modern text-center py-5">
            <i class="bi bi-journal-text" style="font-size: 4rem; color: var(--text-muted);"></i>
            <h5 class="mt-4">Audit Logs Module</h5>
            <p class="text-muted">This module is under development</p>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
