<?php
/**
 * Attendance Management - Main Page
 * Loads attendance module calendar view
 */

session_start();
require_once 'config/database.php';
require_once 'includes/database.php';
require_once 'includes/session_manager.php';

require_authentication();

// Get current user
$current_user = get_logged_in_user();
if (!$current_user) {
    header('Location: login.php');
    exit;
}

$page_title = 'Attendance Management';
$current_page = 'attendance';

// Include header with sidebar
include 'includes/header.php';

// Now include the module content (without its own header)
define('MODULE_EMBEDDED', true);

?>

<div class="dashboard-container">
    <?php include 'modules/attendance/calendar.php'; ?>
</div>

<?php include 'includes/footer.php'; ?>
