<?php
/**
 * AJAX Module Action Handler
 * Handles install/activate/deactivate actions via AJAX
 */

// Prevent any output before JSON
ob_start();

try {
    session_start();
    require_once 'config/database.php';
    require_once 'includes/database.php';
    require_once 'includes/session_manager.php';
    require_once 'includes/ModuleManager.php';

    // Require authentication
    require_authentication();

    // Check admin permission
    $current_user = get_logged_in_user();
    if ($current_user['permission_level'] < 100) {
        throw new Exception('Access denied. Admin permission required.');
    }

    // Get POST data
    $action = $_POST['action'] ?? '';
    $module_id = $_POST['module_id'] ?? '';

    if (empty($action)) {
        throw new Exception('No action specified');
    }

    $pdo = get_database_connection();
    $moduleManager = new ModuleManager($pdo);

    $response = ['success' => false, 'message' => 'Invalid action'];

    switch ($action) {
        case 'install':
            // Install module by running scanAndRegister
            $count = $moduleManager->scanAndRegister();
            $response = [
                'success' => true,
                'message' => 'Module installed successfully. Click Activate to use it.',
                'count' => $count
            ];
            break;

        case 'activate':
            $result = $moduleManager->activate($module_id);
            $response = $result;
            break;

        case 'deactivate':
            $result = $moduleManager->deactivate($module_id);
            $response = $result;
            break;

        case 'uninstall':
            if (isset($_POST['confirm']) && $_POST['confirm'] === 'yes') {
                $result = $moduleManager->uninstall($module_id);
                $response = $result;
            } else {
                $response = ['success' => false, 'message' => 'Confirmation required'];
            }
            break;

        default:
            $response = ['success' => false, 'message' => 'Unknown action: ' . $action];
    }

} catch (Exception $e) {
    $response = [
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ];
}

// Clear any unexpected output
ob_end_clean();

// Send JSON response
header('Content-Type: application/json');
echo json_encode($response);
exit;
?>
