<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "Step 1: Starting session...\n";
session_start();
echo "Session started\n";

echo "Step 2: Checking if logged in...\n";
if (isset($_SESSION['user_id'])) {
    echo "Already logged in, would redirect\n";
}

echo "Step 3: Checking config...\n";
if (!file_exists('../config/database.php')) {
    echo "Config missing, would redirect to install\n";
    exit;
}
echo "Config exists\n";

echo "Step 4: Loading database...\n";
require_once '../config/database.php';
echo "Database loaded: " . (isset($pdo) ? 'YES' : 'NO') . "\n";

echo "Step 5: Loading session_manager...\n";
require_once '../includes/session_manager.php';
echo "Session manager loaded\n";

echo "All steps completed successfully!\n";
