<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

session_start();

// Fake login
$_SESSION['user_id'] = 1;
$_SESSION['username'] = 'test';
$_SESSION['email'] = 'test@test.com';
$_SESSION['permission_level'] = 100;

echo '<h1>Testing Dashboard Load</h1>';
echo '<pre>';

try {
    require_once '../config/database.php';
    echo "✓ Database config loaded\n";
    
    require_once '../includes/database.php';
    echo "✓ Database functions loaded\n";
    
    require_once '../includes/session_manager.php';
    echo "✓ Session manager loaded\n";
    
    require_once '../includes/system_health.php';
    echo "✓ System health loaded\n";
    
    require_once '../includes/resource_manager.php';
    echo "✓ Resource manager loaded\n";
    
    echo "\n=== Testing get_system_capacity ===\n";
    $cap = get_system_capacity();
    print_r($cap);
    
    echo "\nAll functions available - Dashboard should work!\n";
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . ":" . $e->getLine() . "\n";
}

echo '</pre>';
?>
