<?php
/**
 * License Suspended Page
 * Displayed when user tries to login with a suspended license
 */
session_start();

// Get license message from session
$license_message = $_SESSION['license_message'] ?? 'Your license has been suspended. Please contact support.';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>License Suspended - SCMS</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .suspended-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            max-width: 600px;
            width: 100%;
            overflow: hidden;
        }
        .suspended-header {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            color: white;
            padding: 40px;
            text-align: center;
        }
        .suspended-icon {
            font-size: 80px;
            margin-bottom: 20px;
            animation: pulse 2s infinite;
        }
        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.1); }
        }
        .suspended-body {
            padding: 40px;
        }
        .contact-box {
            background: #f8f9fa;
            border-left: 4px solid #f5576c;
            padding: 20px;
            margin-top: 20px;
            border-radius: 8px;
        }
        .contact-box h6 {
            color: #f5576c;
            margin-bottom: 15px;
        }
        .contact-item {
            display: flex;
            align-items: center;
            margin-bottom: 10px;
        }
        .contact-item i {
            color: #f5576c;
            margin-right: 10px;
            font-size: 18px;
        }
        .btn-back {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            color: white;
            padding: 12px 30px;
            border-radius: 25px;
            font-weight: 600;
            transition: transform 0.3s;
        }
        .btn-back:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
            color: white;
        }
    </style>
</head>
<body>
    <div class="suspended-card">
        <div class="suspended-header">
            <div class="suspended-icon">
                <i class="bi bi-shield-exclamation"></i>
            </div>
            <h2 class="mb-0">License Suspended</h2>
        </div>

        <div class="suspended-body">
            <div class="alert alert-danger mb-4">
                <i class="bi bi-exclamation-triangle-fill"></i>
                <strong>Access Denied</strong>
            </div>

            <p class="mb-4">
                <?php echo htmlspecialchars($license_message); ?>
            </p>

            <div class="contact-box">
                <h6><i class="bi bi-headset"></i> Contact Support</h6>
                <p class="small text-muted mb-3">
                    To resolve this issue and restore your license, please contact our support team:
                </p>

                <div class="contact-item">
                    <i class="bi bi-envelope-fill"></i>
                    <span><strong>Email:</strong> <a href="mailto:abz@yours.com">abz@yours.com</a></span>
                </div>

                <div class="contact-item">
                    <i class="bi bi-telephone-fill"></i>
                    <span><strong>Phone:</strong> +44 (0) 20 1234 5678</span>
                </div>

                <div class="contact-item">
                    <i class="bi bi-clock-fill"></i>
                    <span><strong>Hours:</strong> Monday - Friday, 9:00 AM - 5:00 PM GMT</span>
                </div>
            </div>

            <div class="card bg-light mt-4 border-0">
                <div class="card-body">
                    <h6 class="mb-3"><i class="bi bi-info-circle-fill text-info"></i> Common Reasons for Suspension</h6>
                    <ul class="small mb-0">
                        <li>Payment overdue or failed</li>
                        <li>Terms of service violation</li>
                        <li>License transferred to another domain without authorization</li>
                        <li>Exceeding worker limits consistently</li>
                    </ul>
                </div>
            </div>

            <div class="text-center mt-4">
                <a href="login.php" class="btn btn-back">
                    <i class="bi bi-arrow-left-circle"></i> Back to Login
                </a>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
